"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  ENTITY_NAME: true,
  VIEW_ALL: true,
  LEARN_MORE: true,
  LAST_UPDATED: true
};
exports.VIEW_ALL = exports.LEARN_MORE = exports.LAST_UPDATED = exports.ENTITY_NAME = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../../../explore/components/risk_score/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITY_NAME = riskEntity => _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.nameTitle', {
  defaultMessage: '{riskEntity} Name',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity)
  }
});
exports.ENTITY_NAME = ENTITY_NAME;
const VIEW_ALL = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.viewAllLabel', {
  defaultMessage: 'View all'
});
exports.VIEW_ALL = VIEW_ALL;
const LEARN_MORE = riskEntity => _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.learnMore', {
  defaultMessage: 'Learn more about {riskEntity} risk',
  values: {
    riskEntity: (0, _translations.getRiskEntityTranslation)(riskEntity, true)
  }
});
exports.LEARN_MORE = LEARN_MORE;
const LAST_UPDATED = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.riskDashboard.lastUpdatedTitle', {
  defaultMessage: 'Last updated'
});
exports.LAST_UPDATED = LAST_UPDATED;