"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VIEW_ALL_USERS_ANOMALIES = exports.VIEW_ALL_HOSTS_ANOMALIES = exports.VIEW_ALL_ANOMALIES = exports.RUN_JOB = exports.MODULE_NOT_COMPATIBLE_TITLE = exports.JOB_STATUS_WAITING = exports.JOB_STATUS_UNINSTALLED = exports.JOB_STATUS_FAILED = exports.JOB_STATUS_DISABLED = exports.ANOMALY_NAME = exports.ANOMALY_DETECTION_DOCS = exports.ANOMALY_COUNT = exports.ANOMALIES_TOOLTIP = exports.ANOMALIES_TITLE = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ANOMALIES_TITLE = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.anomaliesTitle', {
  defaultMessage: 'Anomalies'
});
exports.ANOMALIES_TITLE = ANOMALIES_TITLE;
const ANOMALY_NAME = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.anomalyName', {
  defaultMessage: 'Anomaly name'
});
exports.ANOMALY_NAME = ANOMALY_NAME;
const ANOMALY_COUNT = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.anomalyCount', {
  defaultMessage: 'Count'
});
exports.ANOMALY_COUNT = ANOMALY_COUNT;
const VIEW_ALL_USERS_ANOMALIES = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.viewUsersAnomalies', {
  defaultMessage: 'View all user anomalies'
});
exports.VIEW_ALL_USERS_ANOMALIES = VIEW_ALL_USERS_ANOMALIES;
const VIEW_ALL_HOSTS_ANOMALIES = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.viewHostsAnomalies', {
  defaultMessage: 'View all host anomalies'
});
exports.VIEW_ALL_HOSTS_ANOMALIES = VIEW_ALL_HOSTS_ANOMALIES;
const VIEW_ALL_ANOMALIES = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.viewAnomalies', {
  defaultMessage: 'View all'
});
exports.VIEW_ALL_ANOMALIES = VIEW_ALL_ANOMALIES;
const RUN_JOB = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.enableJob', {
  defaultMessage: 'Run job'
});
exports.RUN_JOB = RUN_JOB;
const JOB_STATUS_DISABLED = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.jobStatusDisabled', {
  defaultMessage: 'disabled'
});
exports.JOB_STATUS_DISABLED = JOB_STATUS_DISABLED;
const JOB_STATUS_UNINSTALLED = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.jobStatusUninstalled', {
  defaultMessage: 'uninstalled'
});
exports.JOB_STATUS_UNINSTALLED = JOB_STATUS_UNINSTALLED;
const JOB_STATUS_FAILED = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.jobStatusFailed', {
  defaultMessage: 'failed'
});
exports.JOB_STATUS_FAILED = JOB_STATUS_FAILED;
const JOB_STATUS_WAITING = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.jobStatusLoading', {
  defaultMessage: 'Waiting'
});
exports.JOB_STATUS_WAITING = JOB_STATUS_WAITING;
const MODULE_NOT_COMPATIBLE_TITLE = incompatibleJobCount => _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.moduleNotCompatibleTitle', {
  values: {
    incompatibleJobCount
  },
  defaultMessage: '{incompatibleJobCount} {incompatibleJobCount, plural, =1 {job is} other {jobs are}} currently unavailable'
});
exports.MODULE_NOT_COMPATIBLE_TITLE = MODULE_NOT_COMPATIBLE_TITLE;
const ANOMALY_DETECTION_DOCS = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.AnomalyDetectionDocsTitle', {
  defaultMessage: 'Anomaly Detection with Machine Learning'
});
exports.ANOMALY_DETECTION_DOCS = ANOMALY_DETECTION_DOCS;
const ANOMALIES_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.anomalies.anomaliesTooltip', {
  defaultMessage: 'The anomalies table is not filterable via the SIEM global KQL search.'
});
exports.ANOMALIES_TOOLTIP = ANOMALIES_TOOLTIP;