"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.STAT_DIFFERENCE = exports.SOC_TRENDS = exports.NO_DATA_CURRENT = exports.NO_DATA_COMPARE = exports.NO_DATA = exports.NO_CHANGE = exports.CRITICAL_ALERTS_STAT = exports.CRITICAL_ALERTS_DESCRIPTION = exports.CASES_MTTR_STAT = exports.CASES_MTTR_DESCRIPTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOC_TRENDS = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.socTrends', {
  defaultMessage: 'SOC Trends'
});
exports.SOC_TRENDS = SOC_TRENDS;
const CASES_MTTR_STAT = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.mttr', {
  defaultMessage: 'Average case response time'
});
exports.CASES_MTTR_STAT = CASES_MTTR_STAT;
const CASES_MTTR_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.mttrDescription', {
  defaultMessage: 'The average duration (from creation to closure) for your current cases'
});
exports.CASES_MTTR_DESCRIPTION = CASES_MTTR_DESCRIPTION;
const CRITICAL_ALERTS_STAT = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.criticalAlerts', {
  defaultMessage: 'Open critical alerts'
});
exports.CRITICAL_ALERTS_STAT = CRITICAL_ALERTS_STAT;
const CRITICAL_ALERTS_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.criticalAlertsDescription', {
  defaultMessage: 'The count of open critical alerts for the current time range'
});
exports.CRITICAL_ALERTS_DESCRIPTION = CRITICAL_ALERTS_DESCRIPTION;
const NO_CHANGE = dataType => _i18n.i18n.translate('xpack.securitySolution.detectionResponse.noChange', {
  defaultMessage: 'Your {dataType} is unchanged',
  values: {
    dataType
  }
});
exports.NO_CHANGE = NO_CHANGE;
const NO_DATA = dataType => _i18n.i18n.translate('xpack.securitySolution.detectionResponse.noData', {
  defaultMessage: 'There is no {dataType} data to compare',
  values: {
    dataType
  }
});
exports.NO_DATA = NO_DATA;
const NO_DATA_COMPARE = dataType => _i18n.i18n.translate('xpack.securitySolution.detectionResponse.noDataCompare', {
  defaultMessage: 'There is no {dataType} data to compare from the compare time range',
  values: {
    dataType
  }
});
exports.NO_DATA_COMPARE = NO_DATA_COMPARE;
const NO_DATA_CURRENT = dataType => _i18n.i18n.translate('xpack.securitySolution.detectionResponse.noDataCurrent', {
  defaultMessage: 'There is no {dataType} data to compare from the current time range',
  values: {
    dataType
  }
});
exports.NO_DATA_CURRENT = NO_DATA_CURRENT;
const STAT_DIFFERENCE = ({
  upOrDown,
  percentageChange,
  stat,
  statType
}) => _i18n.i18n.translate('xpack.securitySolution.detectionResponse.timeDifference', {
  defaultMessage: `Your {statType} is {upOrDown} by {percentageChange} from {stat}`,
  values: {
    upOrDown,
    percentageChange,
    stat,
    statType
  }
});
exports.STAT_DIFFERENCE = STAT_DIFFERENCE;