"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConditionEntryInput = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _types = require("../../../../../../../common/endpoint/types");
var _translations = require("../../translations");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _path_placeholder = require("../../../../../../../common/utils/path_placeholder");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConditionEntryCell = /*#__PURE__*/(0, _react.memo)(({
  showLabel,
  label = '',
  children
}) => {
  return showLabel ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: label,
    fullWidth: true
  }, children) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
ConditionEntryCell.displayName = 'ConditionEntryCell';
// adding a style prop on EuiFlexGroup works only partially
// and for some odd reason garbles up gridTemplateAreas entry
const InputGroup = _styledComponents.default.div`
  display: grid;
  grid-template-columns: 25% 25% 45% 5%;
  grid-template-areas: 'field operator value remove';
`;
const InputItem = _styledComponents.default.div`
  grid-area: ${({
  gridArea
}) => gridArea};
  align-self: center;
  margin: 4px;
  vertical-align: baseline;
`;
const operatorOptions = Object.keys(_types.OperatorFieldIds).map(value => ({
  dropdownDisplay: _translations.OPERATOR_TITLES[value],
  inputDisplay: _translations.OPERATOR_TITLES[value],
  value: value === 'matches' ? 'wildcard' : 'match'
}));
const ConditionEntryInput = /*#__PURE__*/(0, _react.memo)(({
  os,
  entry,
  showLabels = false,
  onRemove,
  onChange,
  isRemoveDisabled = false,
  onVisited,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const [isVisited, setIsVisited] = (0, _react.useState)(false);
  const handleVisited = (0, _react.useCallback)(() => {
    onVisited === null || onVisited === void 0 ? void 0 : onVisited(entry);
    if (!isVisited) {
      setIsVisited(true);
    }
  }, [entry, isVisited, onVisited]);
  const fieldOptions = (0, _react.useMemo)(() => {
    const getDropdownDisplay = field => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _translations.CONDITION_FIELD_TITLE[field], /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued"
    }, _translations.CONDITION_FIELD_DESCRIPTION[field]));
    return [{
      dropdownDisplay: getDropdownDisplay(_securitysolutionUtils.ConditionEntryField.HASH),
      inputDisplay: _translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.HASH],
      value: _securitysolutionUtils.ConditionEntryField.HASH,
      'data-test-subj': getTestId(`field-type-${_translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.HASH]}`)
    }, {
      dropdownDisplay: getDropdownDisplay(_securitysolutionUtils.ConditionEntryField.PATH),
      inputDisplay: _translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.PATH],
      value: _securitysolutionUtils.ConditionEntryField.PATH,
      'data-test-subj': getTestId(`field-type-${_translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.PATH]}`)
    }, ...(os === _securitysolutionUtils.OperatingSystem.WINDOWS ? [{
      dropdownDisplay: getDropdownDisplay(_securitysolutionUtils.ConditionEntryField.SIGNER),
      inputDisplay: _translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.SIGNER],
      value: _securitysolutionUtils.ConditionEntryField.SIGNER,
      'data-test-subj': getTestId(`field-type-${_translations.CONDITION_FIELD_TITLE[_securitysolutionUtils.ConditionEntryField.SIGNER]}`)
    }] : [])];
  }, [getTestId, os]);
  const handleValueUpdate = (0, _react.useCallback)(ev => onChange({
    ...entry,
    value: ev.target.value
  }, entry), [entry, onChange]);
  const handleFieldUpdate = (0, _react.useCallback)(newField => {
    onChange({
      ...entry,
      field: newField
    }, entry);
    if (entry.value) {
      handleVisited();
    }
  }, [handleVisited, entry, onChange]);
  const handleOperatorUpdate = (0, _react.useCallback)(newOperator => onChange({
    ...entry,
    type: newOperator
  }, entry), [entry, onChange]);
  const handleRemoveClick = (0, _react.useCallback)(() => onRemove(entry), [entry, onRemove]);
  const handleValueOnBlur = (0, _react.useCallback)(() => {
    handleVisited();
  }, [handleVisited]);
  return /*#__PURE__*/_react.default.createElement(InputGroup, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(InputItem, {
    gridArea: "field"
  }, /*#__PURE__*/_react.default.createElement(ConditionEntryCell, {
    showLabel: showLabels,
    label: _translations.ENTRY_PROPERTY_TITLES.field
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: fieldOptions,
    valueOfSelected: entry.field,
    onChange: handleFieldUpdate,
    "data-test-subj": getTestId('field')
  }))), /*#__PURE__*/_react.default.createElement(InputItem, {
    gridArea: "operator"
  }, /*#__PURE__*/_react.default.createElement(ConditionEntryCell, {
    showLabel: showLabels,
    label: _translations.ENTRY_PROPERTY_TITLES.operator
  }, entry.field === _securitysolutionUtils.ConditionEntryField.PATH ? /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    options: operatorOptions,
    onChange: handleOperatorUpdate,
    valueOfSelected: entry.type,
    "data-test-subj": getTestId('operator')
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "operator",
    value: _translations.OPERATOR_TITLES.is,
    "data-test-subj": getTestId('operator'),
    readOnly: true
  }))), /*#__PURE__*/_react.default.createElement(InputItem, {
    gridArea: "value"
  }, /*#__PURE__*/_react.default.createElement(ConditionEntryCell, {
    showLabel: showLabels,
    label: _translations.ENTRY_PROPERTY_TITLES.value
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "value",
    value: entry.value,
    placeholder: (0, _path_placeholder.getPlaceholderTextByOSType)({
      os,
      field: entry.field,
      type: entry.type
    }),
    fullWidth: true,
    required: isVisited,
    onChange: handleValueUpdate,
    onBlur: handleValueOnBlur,
    "data-test-subj": getTestId('value')
  }))), /*#__PURE__*/_react.default.createElement(InputItem, {
    gridArea: "remove"
  }, /*#__PURE__*/_react.default.createElement(ConditionEntryCell, {
    showLabel: showLabels,
    label: '\u00A0'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    color: "danger",
    iconType: "trash",
    onClick: handleRemoveClick,
    isDisabled: isRemoveDisabled,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.trustedapps.logicalConditionBuilder.entry.removeLabel', {
      defaultMessage: 'Remove Entry'
    }),
    "data-test-subj": getTestId('remove')
  }))));
});
exports.ConditionEntryInput = ConditionEntryInput;
ConditionEntryInput.displayName = 'ConditionEntryInput';