"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventCollectionCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionUtils = require("@kbn/securitysolution-utils");
var _styledComponents = require("styled-components");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _empty_value = require("../../../../../../common/components/empty_value");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
var _setting_card = require("./setting_card");
var _types = require("../../../../../../../common/endpoint/types");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapOperatingSystemToPolicyOsKey = {
  [_securitysolutionUtils.OperatingSystem.WINDOWS]: _types.PolicyOperatingSystem.windows,
  [_securitysolutionUtils.OperatingSystem.LINUX]: _types.PolicyOperatingSystem.linux,
  [_securitysolutionUtils.OperatingSystem.MAC]: _types.PolicyOperatingSystem.mac
};

// eslint-disable-next-line @typescript-eslint/no-explicit-any

const EventCollectionCard = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  mode,
  os,
  options,
  selection,
  supplementalOptions,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const isEditMode = mode === 'edit';
  const theme = (0, _react.useContext)(_styledComponents.ThemeContext);
  const totalOptions = options.length;
  const policyOs = mapOperatingSystemToPolicyOsKey[os];
  const selectedCount = (0, _react.useMemo)(() => {
    const supplementalSelectionFields = supplementalOptions ? supplementalOptions.map(value => value.protectionField) : [];
    return Object.entries(selection).filter(([key, value]) => !supplementalSelectionFields.includes(key) ? value : false).length;
  }, [selection, supplementalOptions]);
  return /*#__PURE__*/_react.default.createElement(_setting_card.SettingCard, {
    type: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.eventCollection', {
      defaultMessage: 'Event collection'
    }),
    supportedOss: [os],
    mode: mode,
    selected: selectedCount > 0,
    rightCorner: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      "data-test-subj": getTestId('selectedCount')
    }, _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.eventCollectionsEnabled', {
      defaultMessage: '{selected} / {total} event collections enabled',
      values: {
        selected: selectedCount,
        total: totalOptions
      }
    })),
    dataTestSubj: getTestId()
  }, /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, null, _i18n.i18n.translate('xpack.securitySolution.endpoint.policyDetailsConfig.eventingEvents', {
    defaultMessage: 'Events'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId('options')
  }, options.map(({
    name,
    protectionField
  }) => {
    const keyPath = `${policyOs}.events.${String(protectionField)}`;
    return /*#__PURE__*/_react.default.createElement(EventCheckbox, {
      label: name,
      key: keyPath,
      keyPath: keyPath,
      policy: policy,
      onChange: onChange,
      mode: mode,
      "data-test-subj": getTestId(protectionField)
    });
  }), selectedCount === 0 && !isEditMode && /*#__PURE__*/_react.default.createElement("div", null, (0, _empty_value.getEmptyValue)())), supplementalOptions && supplementalOptions.map(({
    title,
    description,
    name,
    uncheckedName,
    protectionField,
    tooltipText,
    beta,
    indented,
    isDisabled
  }) => {
    const keyPath = `${policyOs}.events.${String(protectionField)}`;
    const isChecked = (0, _lodash.get)(policy, keyPath);
    const fieldString = protectionField;
    if (!isEditMode && !isChecked) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      key: String(protectionField),
      style: indented ? {
        paddingLeft: theme.eui.euiSizeL
      } : {},
      "data-test-subj": getTestId(`${fieldString}Container`)
    }, title && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_setting_card.SettingCardHeader, {
      "data-test-subj": getTestId(`${fieldString}Title`)
    }, title)), description && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      color: "subdued",
      "data-test-subj": getTestId(`${fieldString}Description`)
    }, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(EventCheckbox, {
      label: name,
      unCheckedLabel: uncheckedName,
      key: keyPath,
      keyPath: keyPath,
      policy: policy,
      onChange: onChange,
      mode: mode,
      disabled: isDisabled ? isDisabled(policy) : false,
      "data-test-subj": getTestId(fieldString)
    })), tooltipText && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: tooltipText,
      anchorProps: {
        'data-test-subj': getTestId(`${fieldString}TooltipIcon`)
      }
    })), beta && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: "beta",
      size: "s",
      "data-test-subj": getTestId(`${fieldString}Badge`)
    }))));
  }));
});
exports.EventCollectionCard = EventCollectionCard;
EventCollectionCard.displayName = 'EventCollectionCard';
const EventCheckbox = /*#__PURE__*/(0, _react.memo)(({
  policy,
  onChange,
  label,
  unCheckedLabel,
  mode,
  keyPath,
  disabled,
  'data-test-subj': dataTestSubj
}) => {
  const isChecked = (0, _lodash.get)(policy, keyPath);
  const isEditMode = mode === 'edit';
  const displayLabel = isChecked ? label : unCheckedLabel ? unCheckedLabel : label;
  const checkboxOnChangeHandler = (0, _react.useCallback)(ev => {
    const updatedPolicy = (0, _lodash.cloneDeep)(policy);
    (0, _lodash.set)(updatedPolicy, keyPath, ev.target.checked);
    onChange({
      isValid: true,
      updatedPolicy
    });
  }, [keyPath, onChange, policy]);
  return isEditMode ? /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    key: keyPath,
    id: keyPath,
    label: displayLabel,
    "data-test-subj": dataTestSubj,
    checked: isChecked,
    onChange: checkboxOnChangeHandler,
    disabled: disabled
  }) : isChecked ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": dataTestSubj
  }, displayLabel) : null;
});
EventCheckbox.displayName = 'EventCheckbox';