"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NGAV_NOTE = exports.NGAV = exports.INTERACTIVE_ONLY = exports.ENDPOINT = exports.EDR_NOTE = exports.EDR_ESSENTIAL = exports.EDR_COMPLETE = exports.DATA_COLLECTION_HELP_TEXT = exports.DATA_COLLECTION = exports.CLOUD_SECURITY = exports.ALL_EVENTS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NGAV = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionNGAV', {
  defaultMessage: 'Next-Generation Antivirus (NGAV)'
});
exports.NGAV = NGAV;
const NGAV_NOTE = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionNGAVNote', {
  defaultMessage: 'Note: advanced protections require a platinum license level.'
});
exports.NGAV_NOTE = NGAV_NOTE;
const EDR_ESSENTIAL = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionEDREssential', {
  defaultMessage: 'Essential EDR (Endpoint Detection & Response)'
});
exports.EDR_ESSENTIAL = EDR_ESSENTIAL;
const EDR_COMPLETE = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionEDRComplete', {
  defaultMessage: 'Complete EDR (Endpoint Detection & Response)'
});
exports.EDR_COMPLETE = EDR_COMPLETE;
const EDR_NOTE = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionEDRNote', {
  defaultMessage: 'Note: advanced protections require a platinum license, and full response capabilities require an enterprise license.'
});
exports.EDR_NOTE = EDR_NOTE;
const DATA_COLLECTION = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOptionDataCollection', {
  defaultMessage: 'Data Collection'
});
exports.DATA_COLLECTION = DATA_COLLECTION;
const DATA_COLLECTION_HELP_TEXT = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.packagePolicyTypeEndpointDataCollection', {
  defaultMessage: 'Augment your existing anti-virus solution with advanced data collection and detection'
});
exports.DATA_COLLECTION_HELP_TEXT = DATA_COLLECTION_HELP_TEXT;
const ENDPOINT = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.endpointDropdownOption', {
  defaultMessage: 'Traditional Endpoints (desktops, laptops, virtual machines)'
});
exports.ENDPOINT = ENDPOINT;
const CLOUD_SECURITY = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.cloudDropdownOption', {
  defaultMessage: 'Cloud Workloads (Linux servers or Kubernetes environments)'
});
exports.CLOUD_SECURITY = CLOUD_SECURITY;
const INTERACTIVE_ONLY = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.cloudEventFiltersInteractiveOnly', {
  defaultMessage: 'Interactive only'
});
exports.INTERACTIVE_ONLY = INTERACTIVE_ONLY;
const ALL_EVENTS = _i18n.i18n.translate('xpack.securitySolution.createPackagePolicy.stepConfigure.cloudEventFiltersAllEvents', {
  defaultMessage: 'All events'
});
exports.ALL_EVENTS = ALL_EVENTS;