"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsFlyout = exports.MAX_ALLOWED_RESULTS = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactQuery = require("@tanstack/react-query");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _search_exceptions = require("../../../../../components/search_exceptions");
var _kibana = require("../../../../../../common/lib/kibana");
var _assignable = require("../assignable");
var _artifacts = require("../../../../../hooks/artifacts");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_ALLOWED_RESULTS = 100;
exports.MAX_ALLOWED_RESULTS = MAX_ALLOWED_RESULTS;
const PolicyArtifactsFlyout = /*#__PURE__*/_react.default.memo(({
  policyItem,
  apiClient,
  searchableFields,
  onClose,
  labels
}) => {
  const toasts = (0, _kibana.useToasts)();
  const queryClient = (0, _reactQuery.useQueryClient)();
  const [selectedArtifactIds, setSelectedArtifactIds] = (0, _react.useState)([]);
  const [currentFilter, setCurrentFilter] = (0, _react.useState)('');
  const bulkUpdateMutation = (0, _artifacts.useBulkUpdateArtifact)(apiClient, {
    onSuccess: updatedExceptions => {
      toasts.addSuccess({
        title: labels.flyoutSuccessMessageTitle,
        text: labels.flyoutSuccessMessageText(updatedExceptions)
      });
      queryClient.invalidateQueries(['list', apiClient]);
      onClose();
    },
    onError: () => {
      toasts.addDanger(labels.flyoutErrorMessage);
    }
  });
  const {
    data: artifacts,
    isLoading: isLoadingArtifacts,
    isRefetching: isRefetchingArtifacts
  } = (0, _artifacts.useListArtifact)(apiClient, {
    perPage: MAX_ALLOWED_RESULTS,
    filter: currentFilter,
    excludedPolicies: [policyItem.id, 'all']
  }, searchableFields);
  const {
    data: allNotAssigned,
    isLoading: isLoadingAllNotAssigned
  } = (0, _artifacts.useListArtifact)(apiClient, {
    excludedPolicies: [policyItem.id, 'all']
  }, searchableFields);
  const handleOnSearch = (0, _react.useCallback)(query => {
    setSelectedArtifactIds([]);
    setCurrentFilter(query);
  }, []);
  const handleOnConfirmAction = (0, _react.useCallback)(() => {
    if (!artifacts) {
      return;
    }
    const artifactsToUpdate = [];
    selectedArtifactIds.forEach(selectedId => {
      const artifact = artifacts.data.find(current => current.id === selectedId);
      if (artifact) {
        artifact.tags = [...artifact.tags, `policy:${policyItem.id}`];
        artifactsToUpdate.push(artifact);
      }
    });
    bulkUpdateMutation.mutate(artifactsToUpdate);
  }, [bulkUpdateMutation, artifacts, policyItem.id, selectedArtifactIds]);
  const handleSelectArtifacts = (artifactId, selected) => {
    setSelectedArtifactIds(currentSelectedArtifactIds => selected ? [...currentSelectedArtifactIds, artifactId] : (0, _fp.without)([artifactId], currentSelectedArtifactIds));
  };
  const searchWarningMessage = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    "data-test-subj": "artifacts-too-many-results",
    color: "warning",
    size: "s",
    heading: "h4",
    title: labels.flyoutWarningCalloutTitle
  }, labels.flyoutWarningCalloutMessage(MAX_ALLOWED_RESULTS)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), [labels]);
  const assignableArtifacts = (0, _react.useMemo)(() => (allNotAssigned === null || allNotAssigned === void 0 ? void 0 : allNotAssigned.total) !== 0 && ((artifacts === null || artifacts === void 0 ? void 0 : artifacts.total) !== 0 || currentFilter !== ''), [allNotAssigned === null || allNotAssigned === void 0 ? void 0 : allNotAssigned.total, artifacts === null || artifacts === void 0 ? void 0 : artifacts.total, currentFilter]);
  const isGlobalLoading = (0, _react.useMemo)(() => isLoadingArtifacts || isRefetchingArtifacts || isLoadingAllNotAssigned, [isLoadingAllNotAssigned, isLoadingArtifacts, isRefetchingArtifacts]);
  const noItemsMessage = (0, _react.useMemo)(() => {
    if (isGlobalLoading) {
      return null;
    }

    // there are no artifacts assignable to this policy
    if (!assignableArtifacts) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        titleSize: "xs",
        "data-test-subj": "artifacts-no-assignable-items",
        body: /*#__PURE__*/_react.default.createElement("p", null, labels.flyoutNoArtifactsToBeAssignedMessage)
      });
    }

    // there are no results for the current search
    if ((artifacts === null || artifacts === void 0 ? void 0 : artifacts.total) === 0) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
        titleSize: "xs",
        "data-test-subj": "artifacts-no-items-found",
        body: /*#__PURE__*/_react.default.createElement("p", null, labels.flyoutNoSearchResultsMessage)
      });
    }
  }, [isGlobalLoading, assignableArtifacts, artifacts === null || artifacts === void 0 ? void 0 : artifacts.total, labels.flyoutNoArtifactsToBeAssignedMessage, labels.flyoutNoSearchResultsMessage]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose,
    "data-test-subj": "artifacts-assign-flyout"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, labels.flyoutTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), labels.flyoutSubtitle(policyItem.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, ((artifacts === null || artifacts === void 0 ? void 0 : artifacts.total) || 0) > MAX_ALLOWED_RESULTS ? searchWarningMessage : null, !isLoadingAllNotAssigned && assignableArtifacts && /*#__PURE__*/_react.default.createElement(_search_exceptions.SearchExceptions, {
    onSearch: handleOnSearch,
    placeholder: labels.flyoutSearchPlaceholder,
    hideRefreshButton: true
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_assignable.PolicyArtifactsAssignableList, {
    "data-test-subj": "artifacts-assignable-list",
    artifacts: artifacts,
    selectedArtifactIds: selectedArtifactIds,
    isListLoading: isLoadingArtifacts || isRefetchingArtifacts,
    selectedArtifactsUpdated: handleSelectArtifacts
  }), noItemsMessage), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "artifacts-assign-cancel-button",
    onClick: onClose
  }, labels.flyoutCancelButtonTitle)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    className: "eui-textTruncate",
    style: {
      maxWidth: '300px'
    },
    "data-test-subj": "artifacts-assign-confirm-button",
    fill: true,
    onClick: handleOnConfirmAction,
    isLoading: bulkUpdateMutation.isLoading || isLoadingArtifacts || isRefetchingArtifacts,
    disabled: (0, _fp.isEmpty)(selectedArtifactIds),
    title: policyItem.name
  }, labels.flyoutSubmitButtonTitle(policyItem.name))))));
});
exports.PolicyArtifactsFlyout = PolicyArtifactsFlyout;
PolicyArtifactsFlyout.displayName = 'PolicyArtifactsFlyout';