"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetLinkTo = void 0;
var _react = require("react");
var _i18n = require("@kbn/i18n");
var _use_navigate_to_app_event_handler = require("../../../../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _hooks = require("../../../../../../common/lib/kibana/hooks");
var _constants = require("../../../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useGetLinkTo = (policyId, policyName, getPolicyArtifactsPath, getArtifactPath, location) => {
  const {
    getAppUrl
  } = (0, _hooks.useAppUrl)();
  const {
    toRoutePath,
    toRouteUrl
  } = (0, _react.useMemo)(() => {
    const path = getArtifactPath(location);
    return {
      toRoutePath: path,
      toRouteUrl: getAppUrl({
        path
      })
    };
  }, [getAppUrl, getArtifactPath, location]);
  const policyArtifactsPath = getPolicyArtifactsPath(policyId);
  const policyArtifactRouteState = (0, _react.useMemo)(() => {
    return {
      backButtonLabel: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.artifacts.empty.unassigned.backButtonLabel', {
        defaultMessage: 'Back to {policyName} policy',
        values: {
          policyName
        }
      }),
      onBackButtonNavigateTo: [_constants.APP_UI_ID, {
        path: policyArtifactsPath
      }],
      backButtonUrl: getAppUrl({
        appId: _constants.APP_UI_ID,
        path: policyArtifactsPath
      })
    };
  }, [getAppUrl, policyName, policyArtifactsPath]);
  const onClickHandler = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(_constants.APP_UI_ID, {
    state: policyArtifactRouteState,
    path: toRoutePath
  });
  return {
    onClickHandler,
    toRouteUrl,
    state: policyArtifactRouteState
  };
};
exports.useGetLinkTo = useGetLinkTo;