"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManagementContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _public = require("@kbn/usage-collection-plugin/public");
var _constants = require("../common/constants");
var _ = require("../../app/404");
var _endpoint_hosts = require("./endpoint_hosts");
var _policy = require("./policy");
var _trusted_apps = require("./trusted_apps");
var _constants2 = require("../../../common/constants");
var _spy_routes = require("../../common/utils/route/spy_routes");
var _event_filters = require("./event_filters");
var _routing = require("../common/routing");
var _user_privileges = require("../../common/components/user_privileges");
var _host_isolation_exceptions = require("./host_isolation_exceptions");
var _blocklist = require("./blocklist");
var _response_actions = require("./response_actions");
var _privileged_route = require("../components/privileged_route");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.endpoints
}, /*#__PURE__*/_react.default.createElement(_endpoint_hosts.EndpointsContainer, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.endpoints
}));
const PolicyTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.policies
}, /*#__PURE__*/_react.default.createElement(_policy.PolicyContainer, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.policies
}));
const TrustedAppTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.trustedApps
}, /*#__PURE__*/_react.default.createElement(_trusted_apps.TrustedAppsContainer, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.trustedApps
}));
const EventFilterTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.eventFilters
}, /*#__PURE__*/_react.default.createElement(_event_filters.EventFiltersContainer, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.eventFilters
}));
const HostIsolationExceptionsTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.hostIsolationExceptions
}, /*#__PURE__*/_react.default.createElement(_host_isolation_exceptions.HostIsolationExceptionsContainer, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.hostIsolationExceptions
}));
const ResponseActionsTelemetry = () => /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants2.SecurityPageName.responseActionsHistory
}, /*#__PURE__*/_react.default.createElement(_response_actions.ResponseActionsContainer, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
  pageName: _constants2.SecurityPageName.responseActionsHistory
}));
const ManagementContainer = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    loading,
    canReadPolicyManagement,
    canReadBlocklist,
    canReadTrustedApplications,
    canReadEventFilters,
    canReadActionsLogManagement,
    canReadEndpointList,
    canReadHostIsolationExceptions
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;

  // Lets wait until we can verify permissions
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, null);
  }
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_ENDPOINTS_PATH,
    component: EndpointTelemetry,
    hasPrivilege: canReadEndpointList
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_POLICIES_PATH,
    component: PolicyTelemetry,
    hasPrivilege: canReadPolicyManagement
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_TRUSTED_APPS_PATH,
    component: TrustedAppTelemetry,
    hasPrivilege: canReadTrustedApplications
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_EVENT_FILTERS_PATH,
    component: EventFilterTelemetry,
    hasPrivilege: canReadEventFilters
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_HOST_ISOLATION_EXCEPTIONS_PATH,
    component: HostIsolationExceptionsTelemetry,
    hasPrivilege: canReadHostIsolationExceptions
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_BLOCKLIST_PATH,
    component: _blocklist.BlocklistContainer,
    hasPrivilege: canReadBlocklist
  }), /*#__PURE__*/_react.default.createElement(_privileged_route.PrivilegedRoute, {
    path: _constants.MANAGEMENT_ROUTING_RESPONSE_ACTIONS_HISTORY_PATH,
    component: ResponseActionsTelemetry,
    hasPrivilege: canReadActionsLogManagement
  }), canReadEndpointList && /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.MANAGEMENT_PATH,
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: (0, _routing.getEndpointListPath)({
      name: 'endpointList'
    })
  })), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "*",
    component: _.NotFoundPage
  }));
});
exports.ManagementContainer = ManagementContainer;
ManagementContainer.displayName = 'ManagementContainer';