"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.eventFiltersListQueryHttpMock = exports.esResponseData = exports.ecsEventMock = void 0;
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _found_exception_list_item_schema = require("@kbn/lists-plugin/common/schemas/response/found_exception_list_item_schema.mock");
var _exception_list_item_schema = require("@kbn/lists-plugin/common/schemas/response/exception_list_item_schema.mock");
var _exception_list_summary_schema = require("@kbn/lists-plugin/common/schemas/response/exception_list_summary_schema.mock");
var _http_handler_mock_factory = require("../../../../common/mock/endpoint/http_handler_mock_factory");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ecsEventMock = () => ({
  _id: 'unLfz3gB2mJZsMY3ytx3',
  timestamp: '2021-04-14T15:34:15.330Z',
  _index: '.ds-logs-endpoint.events.process-default-2021.04.12-000001',
  event: {
    category: ['network'],
    id: ['2c4f51be-7736-4ab8-a255-54e7023c4653'],
    kind: ['event'],
    type: ['start']
  },
  host: {
    name: ['Host-tvs68wo3qc'],
    os: {
      family: ['windows'],
      name: ['Windows']
    },
    id: ['a563b365-2bee-40df-adcd-ae84d889f523'],
    ip: ['10.242.233.187']
  },
  user: {
    name: ['uegem17ws4'],
    domain: ['hr8jofpkxp']
  },
  agent: {
    type: ['endpoint']
  },
  process: {
    hash: {
      md5: ['c4653870-99b8-4f36-abde-24812d08a289']
    },
    parent: {
      pid: [4852]
    },
    pid: [3652],
    name: ['lsass.exe'],
    args: ['"C:\\lsass.exe" \\6z9'],
    entity_id: ['9qotd1i8rf'],
    executable: ['C:\\lsass.exe']
  }
});
exports.ecsEventMock = ecsEventMock;
const esResponseData = () => ({
  rawResponse: {
    took: 0,
    timed_out: false,
    _shards: {
      total: 1,
      successful: 1,
      skipped: 0,
      failed: 0
    },
    hits: {
      total: 1,
      max_score: 1,
      hits: [{
        _index: '.ds-logs-endpoint.events.process-default-2021.07.06-000001',
        _id: 'ZihXfHoBP7UhLrksX9-B',
        _score: 1,
        _source: {
          agent: {
            id: '9b5fad11-6cd9-401b-afc1-1c2b0c8a2603',
            type: 'endpoint',
            version: '7.12.2'
          },
          process: {
            args: '"C:\\lsass.exe" \\d6e',
            Ext: {
              ancestry: ['wm6pfs8yo3', 'd0zpkp91jx']
            },
            parent: {
              pid: 2356,
              entity_id: 'wm6pfs8yo3'
            },
            code_signature: {
              subject_name: 'Microsoft',
              status: 'trusted'
            },
            name: 'lsass.exe',
            pid: 2522,
            entity_id: 'hmmlst1ewe',
            executable: 'C:\\lsass.exe',
            hash: {
              md5: 'de8c03a1-099f-4d9b-9a5e-1961c18af19f'
            }
          },
          network: {
            forwarded_ip: '10.105.19.209',
            direction: 'inbound'
          },
          '@timestamp': 1625694621727,
          ecs: {
            version: '1.4.0'
          },
          data_stream: {
            namespace: 'default',
            type: 'logs',
            dataset: 'endpoint.events.process'
          },
          host: {
            hostname: 'Host-15ofk0qkwk',
            os: {
              Ext: {
                variant: 'Windows Pro'
              },
              name: 'Linux',
              family: 'Debian OS',
              version: '10.0',
              platform: 'Windows',
              full: 'Windows 10'
            },
            ip: ['10.133.4.77', '10.135.101.75', '10.137.102.119'],
            name: 'Host-15ofk0qkwk',
            id: 'bae7a849-1ce9-421a-a879-5fee5dcd1fb9',
            mac: ['ad-65-2d-17-aa-95', '63-4-33-c5-c6-90'],
            architecture: 'uwp8xmxk1f'
          },
          event: {
            agent_id_status: 'auth_metadata_missing',
            sequence: 36,
            ingested: '2021-07-06T15:02:18.746828Z',
            kind: 'event',
            id: '02057ac0-0ae5-442c-9082-c5a7489dde09',
            category: 'network',
            type: 'start'
          },
          user: {
            domain: '22bk8yptgw',
            name: 'dlkfiz43rh'
          }
        }
      }]
    }
  },
  indexFields: [],
  indicesExist: [],
  isPartial: false,
  isRunning: false,
  total: 1,
  loaded: 1,
  isRestored: false
});

/**
 * Mock `core.http` methods used by Event Filters List page
 */
exports.esResponseData = esResponseData;
const eventFiltersListQueryHttpMock = (0, _http_handler_mock_factory.httpHandlerMockFactory)([{
  id: 'eventFiltersCreateList',
  method: 'post',
  path: _securitysolutionListConstants.EXCEPTION_LIST_URL,
  handler: () => {
    return (0, _exception_list_item_schema.getExceptionListItemSchemaMock)();
  }
}, {
  id: 'eventFiltersList',
  method: 'get',
  path: `${_securitysolutionListConstants.EXCEPTION_LIST_ITEM_URL}/_find`,
  handler: () => {
    return (0, _found_exception_list_item_schema.getFoundExceptionListItemSchemaMock)();
  }
}, {
  id: 'eventFiltersGetOne',
  method: 'get',
  path: `${_securitysolutionListConstants.EXCEPTION_LIST_ITEM_URL}`,
  handler: () => {
    return (0, _exception_list_item_schema.getExceptionListItemSchemaMock)();
  }
}, {
  id: 'eventFiltersCreateOne',
  method: 'post',
  path: `${_securitysolutionListConstants.EXCEPTION_LIST_ITEM_URL}`,
  handler: () => {
    return (0, _exception_list_item_schema.getExceptionListItemSchemaMock)();
  }
}, {
  id: 'eventFiltersUpdateOne',
  method: 'put',
  path: `${_securitysolutionListConstants.EXCEPTION_LIST_ITEM_URL}`,
  handler: () => {
    return (0, _exception_list_item_schema.getExceptionListItemSchemaMock)();
  }
}, {
  id: 'eventFiltersGetSummary',
  method: 'get',
  path: `${_securitysolutionListConstants.EXCEPTION_LIST_URL}/summary`,
  handler: () => {
    return (0, _exception_list_summary_schema.getSummaryExceptionListSchemaMock)();
  }
}]);
exports.eventFiltersListQueryHttpMock = eventFiltersListQueryHttpMock;