"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableRowActions = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _context_menu_item_nav_by_router = require("../../../../components/context_menu_with_router_support/context_menu_item_nav_by_router");
var _hooks = require("../hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TableRowActions = /*#__PURE__*/(0, _react.memo)(({
  endpointMetadata
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const endpointActions = (0, _hooks.useEndpointActionItems)(endpointMetadata, {
    isEndpointList: true
  });
  const handleCloseMenu = (0, _react.useCallback)(() => setIsOpen(false), [setIsOpen]);
  const handleToggleMenu = (0, _react.useCallback)(() => setIsOpen(!isOpen), [isOpen]);
  const menuItems = (0, _react.useMemo)(() => {
    return endpointActions.map(itemProps => {
      return /*#__PURE__*/_react.default.createElement(_context_menu_item_nav_by_router.ContextMenuItemNavByRouter, (0, _extends2.default)({}, itemProps, {
        onClick: ev => {
          handleCloseMenu();
          if (itemProps.onClick) {
            itemProps.onClick(ev);
          }
        }
      }));
    });
  }, [handleCloseMenu, endpointActions]);
  const panelProps = (0, _react.useMemo)(() => {
    return {
      'data-test-subj': 'tableRowActionsMenuPanel'
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "downRight",
    panelPaddingSize: "none",
    panelProps: panelProps,
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "endpointTableRowActions",
      iconType: "boxesHorizontal",
      onClick: handleToggleMenu,
      "aria-label": _i18n.i18n.translate('xpack.securitySolution.endpoint.list.actionmenu', {
        defaultMessage: 'Open'
      })
    }),
    isOpen: isOpen,
    closePopover: handleCloseMenu
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: menuItems
  }));
});
exports.TableRowActions = TableRowActions;
TableRowActions.displayName = 'EndpointTableRowActions';