"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BlocklistContainer = void 0;
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/usage-collection-plugin/public");
var _constants = require("../../common/constants");
var _ = require("../../../app/404");
var _blocklist = require("./view/blocklist");
var _types = require("../../../app/types");
var _spy_routes = require("../../../common/utils/route/spy_routes");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Provides the routing container for the blocklist related views
 */
const BlocklistContainer = /*#__PURE__*/(0, _react.memo)(() => {
  return /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: _types.SecurityPageName.blocklist
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants.MANAGEMENT_ROUTING_BLOCKLIST_PATH,
    exact: true,
    component: _blocklist.Blocklist
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "*",
    component: _.NotFoundPage
  })), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.blocklist
  }));
});
exports.BlocklistContainer = BlocklistContainer;
BlocklistContainer.displayName = 'BlocklistContainer';