"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSuggestions = useSuggestions;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to get a memoized suggestions interface
 */
function useSuggestions(fn) {
  return (0, _react.useMemo)(() => ({
    getQuerySuggestions: () => undefined,
    hasQuerySuggestions: _ => false,
    getValueSuggestions: fn
  }), [fn]);
}