"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendUploadEndpointRequest = void 0;
var _reactQuery = require("@tanstack/react-query");
var _kibana = require("../../../common/lib/kibana");
var _constants = require("../../../../common/endpoint/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSendUploadEndpointRequest = options => {
  const http = (0, _kibana.useHttp)();
  return (0, _reactQuery.useMutation)(({
    file,
    ...payload
  }) => {
    const formData = new FormData();
    formData.append('file', file, file.name);
    for (const [key, value] of Object.entries(payload)) {
      formData.append(key, typeof value !== 'string' ? JSON.stringify(value) : value);
    }
    return http.post(_constants.UPLOAD_ROUTE, {
      body: formData,
      version: '2023-10-31',
      headers: {
        'Content-Type': undefined // Important in order to let the browser set the appropriate content type
      }
    });
  }, options);
};
exports.useSendUploadEndpointRequest = useSendUploadEndpointRequest;