"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSendReleaseEndpointRequest = void 0;
var _reactQuery = require("@tanstack/react-query");
var _endpoint_isolation = require("../../../common/lib/endpoint_isolation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Create host release requests
 * @param customOptions
 */
const useSendReleaseEndpointRequest = customOptions => {
  return (0, _reactQuery.useMutation)(releaseData => {
    return (0, _endpoint_isolation.unIsolateHost)(releaseData);
  }, customOptions);
};
exports.useSendReleaseEndpointRequest = useSendReleaseEndpointRequest;