"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionLogDateRangePicker = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _common = require("@kbn/kibana-react-plugin/common");
var _public = require("@kbn/kibana-react-plugin/public");
var _common2 = require("@kbn/data-plugin/common");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DatePickerWrapper = _common.euiStyled.div`
  padding-bottom: ${props => `${props.theme.eui.euiSizeL}`};
`;
const ActionLogDateRangePicker = /*#__PURE__*/(0, _react.memo)(({
  dateRangePickerState,
  isDataLoading,
  onRefresh,
  onRefreshChange,
  onTimeChange,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const kibana = (0, _public.useKibana)();
  const {
    uiSettings
  } = kibana.services;
  const [commonlyUsedRanges] = (0, _react.useState)(() => {
    var _uiSettings$get$map, _uiSettings$get;
    return (_uiSettings$get$map = uiSettings === null || uiSettings === void 0 ? void 0 : (_uiSettings$get = uiSettings.get(_common2.UI_SETTINGS.TIMEPICKER_QUICK_RANGES)) === null || _uiSettings$get === void 0 ? void 0 : _uiSettings$get.map(({
      from,
      to,
      display
    }) => {
      return {
        start: from,
        end: to,
        label: display
      };
    })) !== null && _uiSettings$get$map !== void 0 ? _uiSettings$get$map : [];
  });
  return /*#__PURE__*/_react.default.createElement(DatePickerWrapper, {
    "data-test-subj": getTestId('super-date-picker')
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    isLoading: isDataLoading,
    dateFormat: uiSettings.get('dateFormat'),
    commonlyUsedRanges: commonlyUsedRanges,
    end: dateRangePickerState.endDate,
    isPaused: !dateRangePickerState.autoRefreshOptions.enabled,
    onTimeChange: onTimeChange,
    onRefreshChange: onRefreshChange,
    refreshInterval: dateRangePickerState.autoRefreshOptions.duration,
    onRefresh: onRefresh,
    recentlyUsedRanges: dateRangePickerState.recentlyUsedDateRanges,
    start: dateRangePickerState.startDate,
    showUpdateButton: false,
    updateButtonProps: {
      iconOnly: true,
      fill: false
    },
    width: "auto"
  }))));
});
exports.ActionLogDateRangePicker = ActionLogDateRangePicker;
ActionLogDateRangePicker.displayName = 'ActionLogDateRangePicker';