"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GetProcessesActionResult = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_console_action_submitter = require("../hooks/use_console_action_submitter");
var _use_send_get_endpoint_processes_request = require("../../../hooks/response_actions/use_send_get_endpoint_processes_request");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error TS2769
const StyledEuiBasicTable = (0, _styledComponents.default)(_eui.EuiBasicTable)`
  table {
    background-color: transparent;
  }

  .euiTableHeaderCell {
    border-bottom: ${props => props.theme.eui.euiBorderThin};

    .euiTableCellContent__text {
      font-weight: ${props => props.theme.eui.euiFontWeightRegular};
    }
  }

  .euiTableRow {
    &:hover {
      background-color: ${({
  theme: {
    eui
  }
}) => eui.euiColorEmptyShade} !important;
    }

    .euiTableRowCell {
      border-top: none !important;
      border-bottom: none !important;
    }
  }
`;
const GetProcessesActionResult = /*#__PURE__*/(0, _react.memo)(({
  command,
  setStore,
  store,
  status,
  setStatus,
  ResultComponent
}) => {
  var _command$commandDefin, _command$commandDefin2, _command$args$args2;
  const endpointId = (_command$commandDefin = command.commandDefinition) === null || _command$commandDefin === void 0 ? void 0 : (_command$commandDefin2 = _command$commandDefin.meta) === null || _command$commandDefin2 === void 0 ? void 0 : _command$commandDefin2.endpointId;
  const actionCreator = (0, _use_send_get_endpoint_processes_request.useSendGetEndpointProcessesRequest)();
  const actionRequestBody = (0, _react.useMemo)(() => {
    var _command$args$args, _command$args$args$co;
    return endpointId ? {
      endpoint_ids: [endpointId],
      comment: (_command$args$args = command.args.args) === null || _command$args$args === void 0 ? void 0 : (_command$args$args$co = _command$args$args.comment) === null || _command$args$args$co === void 0 ? void 0 : _command$args$args$co[0]
    } : undefined;
  }, [(_command$args$args2 = command.args.args) === null || _command$args$args2 === void 0 ? void 0 : _command$args$args2.comment, endpointId]);
  const {
    result,
    actionDetails: completedActionDetails
  } = (0, _use_console_action_submitter.useConsoleActionSubmitter)({
    ResultComponent,
    setStore,
    store,
    status,
    setStatus,
    actionCreator,
    actionRequestBody,
    dataTestSubj: 'getProcesses'
  });
  const columns = (0, _react.useMemo)(() => [{
    field: 'user',
    'data-test-subj': 'process_list_user',
    name: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getProcesses.table.header.user', {
      defaultMessage: 'USER'
    }),
    width: '10%'
  }, {
    field: 'pid',
    'data-test-subj': 'process_list_pid',
    name: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getProcesses.table.header.pid', {
      defaultMessage: 'PID'
    }),
    width: '5%'
  }, {
    field: 'entity_id',
    'data-test-subj': 'process_list_entity_id',
    name: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getProcesses.table.header.enityId', {
      defaultMessage: 'ENTITY ID'
    }),
    width: '30%'
  }, {
    field: 'command',
    'data-test-subj': 'process_list_command',
    name: _i18n.i18n.translate('xpack.securitySolution.endpointResponseActions.getProcesses.table.header.command', {
      defaultMessage: 'COMMAND'
    }),
    width: '55%'
  }], []);
  const tableEntries = (0, _react.useMemo)(() => {
    if (endpointId) {
      var _completedActionDetai, _completedActionDetai2, _completedActionDetai3;
      return (_completedActionDetai = completedActionDetails === null || completedActionDetails === void 0 ? void 0 : (_completedActionDetai2 = completedActionDetails.outputs) === null || _completedActionDetai2 === void 0 ? void 0 : (_completedActionDetai3 = _completedActionDetai2[endpointId]) === null || _completedActionDetai3 === void 0 ? void 0 : _completedActionDetai3.content.entries) !== null && _completedActionDetai !== void 0 ? _completedActionDetai : [];
    }
    return [];
  }, [completedActionDetails === null || completedActionDetails === void 0 ? void 0 : completedActionDetails.outputs, endpointId]);
  if (!completedActionDetails || !completedActionDetails.wasSuccessful) {
    return result;
  }

  // Show results
  return /*#__PURE__*/_react.default.createElement(ResultComponent, {
    "data-test-subj": "getProcessesSuccessCallout",
    showTitle: false
  }, /*#__PURE__*/_react.default.createElement(StyledEuiBasicTable, {
    "data-test-subj": 'getProcessListTable',
    items: [...tableEntries],
    columns: columns
  }));
});
exports.GetProcessesActionResult = GetProcessesActionResult;
GetProcessesActionResult.displayName = 'GetProcessesActionResult';