"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExecuteActionHostResponse = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _translations = require("../endpoint_response_actions_list/translations");
var _response_action_file_download_link = require("../response_action_file_download_link");
var _execute_action_host_response_output = require("./execute_action_host_response_output");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExecuteActionHostResponse = /*#__PURE__*/(0, _react.memo)(({
  action,
  agentId = action.agents[0],
  canAccessFileDownloadLink,
  textSize = 's',
  'data-test-subj': dataTestSubj
}) => {
  const outputContent = (0, _react.useMemo)(() => action.outputs && action.outputs[agentId] && action.outputs[agentId].content, [action.outputs, agentId]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_response_action_file_download_link.ResponseActionFileDownloadLink, {
    action: action,
    buttonTitle: _translations.EXECUTE_FILE_LINK_TITLE,
    canAccessFileDownloadLink: canAccessFileDownloadLink,
    "data-test-subj": `${dataTestSubj}-getExecuteLink`,
    textSize: textSize
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  })), outputContent && /*#__PURE__*/_react.default.createElement(_execute_action_host_response_output.ExecuteActionHostResponseOutput, {
    outputContent: outputContent,
    "data-test-subj": `${dataTestSubj}-executeResponseOutput`,
    textSize: textSize
  }));
});
exports.ExecuteActionHostResponse = ExecuteActionHostResponse;
ExecuteActionHostResponse.displayName = 'ExecuteActionHostResponse';