"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getArtifactTagsByEffectedPolicySelection = getArtifactTagsByEffectedPolicySelection;
exports.getArtifactTagsWithoutPolicies = getArtifactTagsWithoutPolicies;
exports.getEffectedPolicySelectionByTags = getEffectedPolicySelectionByTags;
exports.isGlobalPolicyEffected = isGlobalPolicyEffected;
var _constants = require("../../../../common/endpoint/service/artifacts/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Given a list of artifact tags, returns the tags that are not policy tags
 * policy tags follow the format: `policy:id`
 */
function getArtifactTagsWithoutPolicies(tags) {
  return (tags === null || tags === void 0 ? void 0 : tags.filter(tag => !tag.startsWith('policy:'))) || [];
}

/**
 * Return a list of artifact policy tags based on a current
 * selection by the EffectedPolicySelection component.
 */
function getArtifactTagsByEffectedPolicySelection(selection, otherTags = []) {
  if (selection.isGlobal) {
    return [_constants.GLOBAL_ARTIFACT_TAG, ...otherTags];
  }
  const newTags = selection.selected.map(policy => {
    return `policy:${policy.id}`;
  });
  return newTags.concat(otherTags);
}

/**
 * Given a list of an Exception item tags it will return
 * the parsed policies from it.
 *
 * Policy tags follow the pattern `policy:id`
 * non policy tags will be ignored.
 */
function getEffectedPolicySelectionByTags(tags, policies) {
  if (tags.find(tag => tag === _constants.GLOBAL_ARTIFACT_TAG)) {
    return {
      isGlobal: true,
      selected: []
    };
  }
  const selected = tags.reduce((acc, tag) => {
    // edge case: a left over tag with a non-existed policy
    // will be removed by veryfing the policy exists
    const id = tag.split(':')[1];
    const foundPolicy = policies.find(policy => policy.id === id);
    if (foundPolicy !== undefined) {
      acc.push(foundPolicy);
    }
    return acc;
  }, []);
  return {
    isGlobal: false,
    selected
  };
}
function isGlobalPolicyEffected(tags) {
  return tags !== undefined && tags.find(tag => tag === _constants.GLOBAL_ARTIFACT_TAG) !== undefined;
}