"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LongRunningCommandHint = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _console_text = require("./console_text");
var _use_data_test_subj = require("../hooks/state_selectors/use_data_test_subj");
var _use_test_id_generator = require("../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LongRunningCommandHint = /*#__PURE__*/(0, _react.memo)(() => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)((0, _use_data_test_subj.useDataTestSubj)());
  return /*#__PURE__*/_react.default.createElement(_console_text.ConsoleText, {
    "data-test-subj": getTestId('longRunningCommandHint')
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.console.longRunningCommandHintMessage",
    defaultMessage: "Hint: We are still working on this task. You may leave the console or place another command while this command is processing."
  }));
});
exports.LongRunningCommandHint = LongRunningCommandHint;
LongRunningCommandHint.displayName = 'LongRunningCommandHint';