"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackToExternalAppSecondaryButton = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _use_navigate_to_app_event_handler = require("../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BackToExternalAppSecondaryButton = /*#__PURE__*/(0, _react.memo)(({
  backButtonLabel,
  backButtonUrl,
  onBackButtonNavigateTo,
  ...commonProps
}) => {
  const handleBackOnClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(...onBackButtonNavigateTo);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiButtonEmpty, (0, _extends2.default)({}, commonProps, {
      "data-test-subj": "backToOrigin",
      size: "s",
      href: backButtonUrl,
      onClick: handleBackOnClick,
      textProps: {
        className: 'text'
      }
    }), backButtonLabel || /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.list.backButton",
      defaultMessage: "Back"
    }))
  );
});
exports.BackToExternalAppSecondaryButton = BackToExternalAppSecondaryButton;
BackToExternalAppSecondaryButton.displayName = 'BackToExternalAppSecondaryButton';