"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextValueDisplay = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _empty_value = require("../../../../common/components/empty_value");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Common component for displaying consistent text across the card. Changes here could impact all of
 * display of values on the card
 */
const TextValueDisplay = /*#__PURE__*/(0, _react.memo)(({
  bold,
  truncate,
  size = 's',
  withTooltip = false,
  'data-test-subj': dataTestSubj,
  children
}) => {
  const cssClassNames = (0, _react.useMemo)(() => {
    return (0, _classnames.default)({
      'eui-textTruncate': truncate,
      'eui-textBreakWord': true
    });
  }, [truncate]);
  const textContent = (0, _react.useMemo)(() => {
    return bold ? /*#__PURE__*/_react.default.createElement("strong", null, children) : children;
  }, [bold, children]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    className: cssClassNames,
    size: size,
    "data-test-subj": dataTestSubj
  }, withTooltip && 'string' === typeof children && children.length > 0 && children !== (0, _empty_value.getEmptyValue)() ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    anchorClassName: cssClassNames,
    content: children,
    position: "top"
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, textContent)) : textContent);
});
exports.TextValueDisplay = TextValueDisplay;
TextValueDisplay.displayName = 'TextValueDisplay';