"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ArtifactCardGrid = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _artifact_entry_card = require("../artifact_entry_card");
var _paginated_content = require("../paginated_content");
var _grid_header = require("./components/grid_header");
var _use_test_id_generator = require("../../hooks/use_test_id_generator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PaginatedContent = _paginated_content.PaginatedContent;
const ArtifactCardGrid = /*#__PURE__*/(0, _react.memo)(({
  items: _items,
  cardComponentProps,
  onPageChange,
  onExpandCollapse,
  'data-test-subj': dataTestSubj,
  ...paginatedContentProps
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  const items = _items;

  // The list of card props that the caller can define

  const callerDefinedCardProps = (0, _react.useMemo)(() => {
    const cardProps = new Map();
    for (const artifact of items) {
      cardProps.set(artifact, cardComponentProps ? cardComponentProps(artifact) : {});
    }
    return cardProps;
  }, [cardComponentProps, items]);

  // Handling of what is expanded or collapsed is done by looking at the at what the caller card's
  // `expanded` prop value was and then invert it for the card that the user clicked expand/collapse
  const handleCardExpandCollapse = (0, _react.useCallback)(item => {
    const expanded = [];
    const collapsed = [];
    for (const [artifact, currentCardProps] of callerDefinedCardProps) {
      const currentExpandedState = Boolean(currentCardProps.expanded);
      const newExpandedState = artifact === item ? !currentExpandedState : currentExpandedState;
      if (newExpandedState) {
        expanded.push(artifact);
      } else {
        collapsed.push(artifact);
      }
    }
    onExpandCollapse({
      expanded,
      collapsed
    });
  }, [callerDefinedCardProps, onExpandCollapse]);
  const isEverythingExpanded = (0, _react.useMemo)(() => {
    for (const [_, currentCardProps] of callerDefinedCardProps) {
      const currentExpandedState = Boolean(currentCardProps.expanded);
      if (!currentExpandedState) {
        return false;
      }
    }
    return true;
  }, [callerDefinedCardProps]);
  const handleCardExpandCollapseAll = (0, _react.useCallback)(() => {
    let expanded = [];
    let collapsed = [];
    if (!isEverythingExpanded) {
      expanded = Array.from(callerDefinedCardProps.keys());
    } else {
      collapsed = Array.from(callerDefinedCardProps.keys());
    }
    onExpandCollapse({
      expanded,
      collapsed
    });
  }, [callerDefinedCardProps, onExpandCollapse, isEverythingExpanded]);

  // Full list of card props that includes the actual artifact and the callbacks

  const fullCardProps = (0, _react.useMemo)(() => {
    const newFullCardProps = new Map();
    for (const [artifact, cardProps] of callerDefinedCardProps) {
      var _cardProps$dataTest;
      newFullCardProps.set(artifact, {
        ...cardProps,
        item: artifact,
        onExpandCollapse: () => handleCardExpandCollapse(artifact),
        'data-test-subj': (_cardProps$dataTest = cardProps['data-test-subj']) !== null && _cardProps$dataTest !== void 0 ? _cardProps$dataTest : getTestId('card')
      });
    }
    return newFullCardProps;
  }, [callerDefinedCardProps, getTestId, handleCardExpandCollapse]);
  const handleItemComponentProps = (0, _react.useCallback)(item => {
    // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
    return fullCardProps.get(item);
  }, [fullCardProps]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_grid_header.GridHeader, {
    expandAllIconType: isEverythingExpanded ? 'fold' : 'unfold',
    onExpandCollapseAll: handleCardExpandCollapseAll,
    "data-test-subj": getTestId('header')
  }), /*#__PURE__*/_react.default.createElement(PaginatedContent, (0, _extends2.default)({}, paginatedContentProps, {
    "data-test-subj": dataTestSubj,
    items: items,
    ItemComponent: _artifact_entry_card.ArtifactEntryCollapsibleCard,
    itemComponentProps: handleItemComponentProps,
    onChange: onPageChange
  })));
});
exports.ArtifactCardGrid = ArtifactCardGrid;
ArtifactCardGrid.displayName = 'ArtifactCardGrid';