"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.copyFunction = void 0;
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Copy to clipboard wrapper component. It allows adding a copy to clipboard functionality to any element.
 * It expects the value to be copied with an optional function to modify the value if necessary.
 *
 * @param copy the copy method from EuiCopy
 * @param rawValue the value to save to the clipboard
 * @param modifier  a function to modify the raw value before saving to the clipboard
 */
const copyFunction = (copy, rawValue, modifier) => {
  copy();
  if (modifier) {
    const modifiedCopyValue = modifier(rawValue);
    (0, _eui.copyToClipboard)(modifiedCopyValue);
  } else {
    (0, _eui.copyToClipboard)(rawValue);
  }
};
exports.copyFunction = copyFunction;