"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutNavigation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Navigation menu on the right panel only, with expand/collapse button and option to
 * pass in a list of actions to be displayed on top.
 */
const FlyoutNavigation = /*#__PURE__*/(0, _react.memo)(({
  flyoutIsExpandable = false,
  expandDetails,
  actions
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    closeLeftPanel,
    panels
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const isExpanded = !!panels.left;
  const collapseDetails = (0, _react.useCallback)(() => closeLeftPanel(), [closeLeftPanel]);
  const collapseButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    onClick: collapseDetails,
    iconType: "arrowEnd",
    size: "s",
    "data-test-subj": _test_ids.COLLAPSE_DETAILS_BUTTON_TEST_ID,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.collapseDetailButtonAriaLabel', {
      defaultMessage: 'Collapse details'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.collapseDetailButtonLabel",
    defaultMessage: "Collapse details"
  })), [collapseDetails]);
  const expandButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "left",
    onClick: expandDetails,
    iconType: "arrowStart",
    size: "s",
    "data-test-subj": _test_ids.EXPAND_DETAILS_BUTTON_TEST_ID,
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.header.expandDetailButtonAriaLabel', {
      defaultMessage: 'Expand details'
    })
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.header.expandDetailButtonLabel",
    defaultMessage: "Expand details"
  })), [expandDetails]);
  return flyoutIsExpandable || actions ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    alignItems: "center",
    gutterSize: "none",
    responsive: false,
    css: (0, _react2.css)`
            padding-left: ${euiTheme.size.s};
            padding-right: ${euiTheme.size.xl};
            height: ${euiTheme.size.xxl};
          `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, flyoutIsExpandable && expandDetails && (isExpanded ? collapseButton : expandButton)), actions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": _test_ids.HEADER_ACTIONS_TEST_ID
  }, actions))) : null;
});
exports.FlyoutNavigation = FlyoutNavigation;
FlyoutNavigation.displayName = 'FlyoutNavigation';