"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPanelHeader = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _securitySolutionNavigation = require("@kbn/security-solution-navigation");
var _managed_details = require("../../../../common/search_strategy/security_solution/users/managed_details");
var _redirect_to_users = require("../../../common/components/link_to/redirect_to_users");
var _links = require("../../../common/components/links");
var _formatted_date = require("../../../common/components/formatted_date");
var _flyout_header = require("../../shared/components/flyout_header");
var _flyout_title = require("../../shared/components/flyout_title");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserPanelHeader = ({
  userName,
  observedUser,
  managedUser
}) => {
  var _managedUser$data, _managedUser$data$Man, _managedUser$data$Man2, _managedUser$data2, _managedUser$data2$Ma, _managedUser$data2$Ma2;
  const oktaTimestamp = (_managedUser$data = managedUser.data) === null || _managedUser$data === void 0 ? void 0 : (_managedUser$data$Man = _managedUser$data[_managed_details.ManagedUserDatasetKey.OKTA]) === null || _managedUser$data$Man === void 0 ? void 0 : (_managedUser$data$Man2 = _managedUser$data$Man.fields) === null || _managedUser$data$Man2 === void 0 ? void 0 : _managedUser$data$Man2['@timestamp'][0];
  const entraTimestamp = (_managedUser$data2 = managedUser.data) === null || _managedUser$data2 === void 0 ? void 0 : (_managedUser$data2$Ma = _managedUser$data2[_managed_details.ManagedUserDatasetKey.ENTRA]) === null || _managedUser$data2$Ma === void 0 ? void 0 : (_managedUser$data2$Ma2 = _managedUser$data2$Ma.fields) === null || _managedUser$data2$Ma2 === void 0 ? void 0 : _managedUser$data2$Ma2['@timestamp'][0];
  const isManaged = !!oktaTimestamp || !!entraTimestamp;
  const lastSeenDate = (0, _react.useMemo)(() => (0, _fp.max)([observedUser.lastSeen.date, entraTimestamp, oktaTimestamp].map(el => el && new Date(el))), [oktaTimestamp, entraTimestamp, observedUser.lastSeen]);
  return /*#__PURE__*/_react.default.createElement(_flyout_header.FlyoutHeader, {
    "data-test-subj": "user-panel-header"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    responsive: false,
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    "data-test-subj": 'user-panel-header-lastSeen'
  }, lastSeenDate && /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: lastSeenDate
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_links.SecuritySolutionLinkAnchor, {
    deepLinkId: _securitySolutionNavigation.SecurityPageName.users,
    path: (0, _redirect_to_users.getUsersDetailsUrl)(userName),
    target: '_blank',
    external: false
  }, /*#__PURE__*/_react.default.createElement(_flyout_title.FlyoutTitle, {
    title: userName,
    iconType: 'user',
    isLink: true
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, observedUser.lastSeen.date && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "user-panel-header-observed-badge",
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.user.observedBadge",
    defaultMessage: "Observed"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isManaged && /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": "user-panel-header-managed-badge",
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.user.managedBadge",
    defaultMessage: "Managed"
  })))))));
};
exports.UserPanelHeader = UserPanelHeader;