"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserPanelContent = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _managed_user = require("../../../timelines/components/side_panel/new_user_detail/managed_user");
var _observed_user = require("../../../timelines/components/side_panel/new_user_detail/observed_user");
var _risk_summary = require("../shared/components/risk_summary");
var _ = require(".");
var _flyout_body = require("../../shared/components/flyout_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserPanelContent = ({
  observedUser,
  managedUser,
  riskScoreState,
  contextID,
  scopeId,
  isDraggable
}) => {
  var _riskScoreState$data;
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, null, riskScoreState.isModuleEnabled && ((_riskScoreState$data = riskScoreState.data) === null || _riskScoreState$data === void 0 ? void 0 : _riskScoreState$data.length) !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_risk_summary.RiskSummary, {
    riskScoreData: riskScoreState,
    queryId: _.USER_PANEL_RISK_SCORE_QUERY_ID
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  })), /*#__PURE__*/_react.default.createElement(_observed_user.ObservedUser, {
    observedUser: observedUser,
    contextID: contextID,
    scopeId: scopeId,
    isDraggable: isDraggable
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_managed_user.ManagedUser, {
    managedUser: managedUser,
    contextID: contextID,
    isDraggable: isDraggable
  }));
};
exports.UserPanelContent = UserPanelContent;