"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskInputsUtilityBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_risk_input_actions_panels = require("../hooks/use_risk_input_actions_panels");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskInputsUtilityBar = /*#__PURE__*/_react.default.memo(({
  selectedAlerts,
  pagination
}) => {
  var _pagination$pageSize;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsPopoverOpen(!isPopoverOpen), [isPopoverOpen]);
  const closePopover = (0, _react.useCallback)(() => setIsPopoverOpen(false), []);
  const panels = (0, _use_risk_input_actions_panels.useRiskInputActionsPanels)(selectedAlerts, closePopover);
  const displayedCurrentPage = pagination.pageIndex + 1;
  const pageSize = (_pagination$pageSize = pagination.pageSize) !== null && _pagination$pageSize !== void 0 ? _pagination$pageSize : 10;
  const fromItem = pagination.pageIndex * pageSize + 1;
  const toItem = Math.min(pagination.totalItemCount, pageSize * displayedCurrentPage);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "risk-input-utility-bar",
    alignItems: "center",
    justifyContent: "flexStart",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: (0, _react2.css)`
              padding: ${euiTheme.size.s} 0;
            `
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, pagination.totalItemCount <= 1 ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.utilityBar.selectionTextSingle",
    defaultMessage: "Showing {totalInputs} {riskInputs}",
    values: {
      totalInputs: pagination.totalItemCount,
      riskInputs: /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.utilityBar.riskInput",
        defaultMessage: "Risk input"
      }))
    }
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.entityDetails.riskInputs.utilityBar.selectionTextRange",
    defaultMessage: "Showing {displayedRange} of {totalInputs} {riskInputs}",
    values: {
      displayedRange: /*#__PURE__*/_react.default.createElement("b", null, `${fromItem}-${toItem}`),
      totalInputs: pagination.totalItemCount,
      riskInputs: /*#__PURE__*/_react.default.createElement("b", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.entityDetails.riskInputs.utilityBar.riskInputs",
        defaultMessage: "Risk inputs"
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, selectedAlerts.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      onClick: togglePopover,
      size: "xs",
      iconSide: "right",
      iconType: "arrowDown",
      flush: "left"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.entityDetails.riskInputs.utilityBar.text",
      defaultMessage: "{totalSelectedInputs} selected risk input",
      values: {
        totalSelectedInputs: selectedAlerts.length
      }
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    panels: panels,
    initialPanelId: 0
  })))));
});
exports.RiskInputsUtilityBar = RiskInputsUtilityBar;
RiskInputsUtilityBar.displayName = 'RiskInputsUtilityBar';