"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AssetDocumentLeftPanelKey = exports.AssetDocumentLeftPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _i18nReact = require("@kbn/i18n-react");
var _context = require("../../document_details/right/context");
var _header = require("../../document_details/right/header");
var _content = require("../../document_details/right/content");
var _json_tab = require("../../document_details/right/tabs/json_tab");
var _table_tab = require("../../document_details/right/tabs/table_tab");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AssetDocumentLeftPanelKey = 'asset-document-details-left';
exports.AssetDocumentLeftPanelKey = AssetDocumentLeftPanelKey;
const tabs = [{
  id: 'table',
  'data-test-subj': _test_ids.TABLE_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.header.tableTabLabel",
    defaultMessage: "Table"
  }),
  content: /*#__PURE__*/_react.default.createElement(_table_tab.TableTab, null)
}, {
  id: 'json',
  'data-test-subj': _test_ids.JSON_TAB_TEST_ID,
  name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.left.header.jsonTabLabel",
    defaultMessage: "JSON"
  }),
  content: /*#__PURE__*/_react.default.createElement(_json_tab.JsonTab, null)
}];
const AssetDocumentLeftPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const selectedTabId = (0, _react.useMemo)(() => {
    var _tabs$map$find;
    const defaultTab = tabs[0].id;
    if (!path) return defaultTab;
    return (_tabs$map$find = tabs.map(tab => tab.id).find(tabId => tabId === path.tab)) !== null && _tabs$map$find !== void 0 ? _tabs$map$find : defaultTab;
  }, [path]);
  const setSelectedTabId = tabId => {
    openLeftPanel({
      id: AssetDocumentLeftPanelKey,
      path: {
        tab: tabId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    tabs: tabs,
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    tabs: tabs,
    selectedTabId: selectedTabId
  }));
});
exports.AssetDocumentLeftPanel = AssetDocumentLeftPanel;
AssetDocumentLeftPanel.displayName = 'AssetDocumentLeftPanel';