"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertHighlightedFieldsToTableRow = exports.convertHighlightedFieldsToPrevalenceFilters = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Converts the highlighted fields to a format that can be consumed by the HighlightedFields component
 * @param highlightedFields
 * @param scopeId
 */
const convertHighlightedFieldsToTableRow = (highlightedFields, scopeId, isPreview) => {
  const fieldNames = Object.keys(highlightedFields);
  return fieldNames.map(fieldName => {
    const values = highlightedFields[fieldName].values;
    const overrideFieldName = highlightedFields[fieldName].overrideField;
    const field = overrideFieldName ? overrideFieldName : fieldName;
    return {
      field,
      description: {
        field,
        ...(overrideFieldName ? {
          originalField: fieldName
        } : {}),
        values,
        scopeId,
        isPreview
      }
    };
  });
};

/**
 * Converts the highlighted fields to a format that can be consumed by the prevalence query
 * @param highlightedFields
 */
exports.convertHighlightedFieldsToTableRow = convertHighlightedFieldsToTableRow;
const convertHighlightedFieldsToPrevalenceFilters = highlightedFields => {
  const fieldNames = Object.keys(highlightedFields);
  return fieldNames.reduce((acc, curr) => {
    const values = highlightedFields[curr].values;
    return {
      ...acc,
      [curr]: {
        terms: {
          [curr]: values
        }
      }
    };
  }, []);
};
exports.convertHighlightedFieldsToPrevalenceFilters = convertHighlightedFieldsToPrevalenceFilters;