"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonTab = void 0;
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/unified-doc-viewer-plugin/public");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _copy_to_clipboard = require("../../../shared/utils/copy_to_clipboard");
var _test_ids = require("./test_ids");
var _context = require("../context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FLYOUT_BODY_PADDING = 24;
const COPY_TO_CLIPBOARD_BUTTON_HEIGHT = 24;
const FLYOUT_FOOTER_HEIGHT = 72;

/**
 * Json view displayed in the document details expandable flyout right section
 */
const JsonTab = /*#__PURE__*/(0, _react.memo)(() => {
  const {
    searchHit,
    isPreview
  } = (0, _context.useRightPanelContext)();
  const jsonValue = JSON.stringify(searchHit, null, 2);
  const flexGroupElement = (0, _react.useRef)(null);
  const [editorHeight, setEditorHeight] = (0, _react.useState)();
  (0, _react.useEffect)(() => {
    var _flexGroupElement$cur;
    const topPosition = (flexGroupElement === null || flexGroupElement === void 0 ? void 0 : (_flexGroupElement$cur = flexGroupElement.current) === null || _flexGroupElement$cur === void 0 ? void 0 : _flexGroupElement$cur.getBoundingClientRect().top) || 0;
    const footerOffset = isPreview ? 0 : FLYOUT_FOOTER_HEIGHT;
    const height = window.innerHeight - topPosition - COPY_TO_CLIPBOARD_BUTTON_HEIGHT - FLYOUT_BODY_PADDING - footerOffset;
    if (height === 0) {
      return;
    }
    setEditorHeight(height);
  }, [setEditorHeight, isPreview]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    ref: flexGroupElement,
    direction: "column",
    gutterSize: "none",
    "data-test-subj": _test_ids.JSON_TAB_CONTENT_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: 'flexEnd'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: jsonValue
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: 'copyClipboard',
    size: 'xs',
    "aria-label": _i18n.i18n.translate('xpack.securitySolution.flyout.right.jsonTab.copyToClipboardButtonAriaLabel', {
      defaultMessage: 'Copy to clipboard'
    }),
    "data-test-subj": _test_ids.JSON_TAB_COPY_TO_CLIPBOARD_BUTTON_TEST_ID,
    onClick: () => (0, _copy_to_clipboard.copyFunction)(copy, jsonValue),
    onKeyDown: () => (0, _copy_to_clipboard.copyFunction)(copy, jsonValue)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.jsonTab.copyToClipboardButtonLabel",
    defaultMessage: "Copy to clipboard"
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_public.JsonCodeEditor, {
    json: searchHit,
    height: editorHeight,
    hasLineNumbers: true
  })));
});
exports.JsonTab = JsonTab;
JsonTab.displayName = 'JsonTab';