"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelNavigation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _header_actions = require("./components/header_actions");
var _flyout_navigation = require("../../shared/components/flyout_navigation");
var _left = require("../left");
var _context = require("./context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PanelNavigation = /*#__PURE__*/(0, _react.memo)(({
  flyoutIsExpandable
}) => {
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    eventId,
    indexName,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const expandDetails = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _left.DocumentDetailsLeftPanelKey,
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  return /*#__PURE__*/_react.default.createElement(_flyout_navigation.FlyoutNavigation, {
    flyoutIsExpandable: flyoutIsExpandable,
    expandDetails: expandDetails,
    actions: /*#__PURE__*/_react.default.createElement(_header_actions.HeaderActions, null)
  });
});
exports.PanelNavigation = PanelNavigation;
PanelNavigation.displayName = 'PanelNavigation';