"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RightPanel = exports.DocumentDetailsRightPanelKey = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _event_kinds = require("../shared/constants/event_kinds");
var _utils = require("../shared/utils");
var _context = require("./context");
var _navigation = require("./navigation");
var _header = require("./header");
var _content = require("./content");
var _tabs = require("./tabs");
var _footer = require("./footer");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentDetailsRightPanelKey = 'document-details-right';
exports.DocumentDetailsRightPanelKey = DocumentDetailsRightPanelKey;
/**
 * Panel to be displayed in the document details expandable flyout right section
 */
const RightPanel = /*#__PURE__*/(0, _react.memo)(({
  path
}) => {
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    eventId,
    getFieldsData,
    indexName,
    scopeId,
    isPreview
  } = (0, _context.useRightPanelContext)();

  // for 8.10, we only render the flyout in its expandable mode if the document viewed is of type signal
  const documentIsSignal = (0, _utils.getField)(getFieldsData('event.kind')) === _event_kinds.EventKind.signal;
  const tabsDisplayed = documentIsSignal ? _tabs.tabs : _tabs.tabs.filter(tab => tab.id !== 'overview');
  const selectedTabId = (0, _react.useMemo)(() => {
    var _tabsDisplayed$map$fi;
    const defaultTab = tabsDisplayed[0].id;
    if (!path) return defaultTab;
    return (_tabsDisplayed$map$fi = tabsDisplayed.map(tab => tab.id).find(tabId => tabId === path.tab)) !== null && _tabsDisplayed$map$fi !== void 0 ? _tabsDisplayed$map$fi : defaultTab;
  }, [path, tabsDisplayed]);
  const setSelectedTabId = tabId => {
    openRightPanel({
      id: DocumentDetailsRightPanelKey,
      path: {
        tab: tabId
      },
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_navigation.PanelNavigation, {
    flyoutIsExpandable: documentIsSignal
  }), /*#__PURE__*/_react.default.createElement(_header.PanelHeader, {
    tabs: tabsDisplayed,
    selectedTabId: selectedTabId,
    setSelectedTabId: setSelectedTabId
  }), /*#__PURE__*/_react.default.createElement(_content.PanelContent, {
    tabs: tabsDisplayed,
    selectedTabId: selectedTabId
  }), /*#__PURE__*/_react.default.createElement(_footer.PanelFooter, {
    isPreview: isPreview
  }));
});
exports.RightPanel = RightPanel;
RightPanel.displayName = 'RightPanel';