"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRightPanelContext = exports.RightPanelProvider = exports.RightPanelContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _use_event_details = require("../shared/hooks/use_event_details");
var _flyout_error = require("../../shared/components/flyout_error");
var _flyout_loading = require("../../shared/components/flyout_loading");
var _helpers = require("../../../timelines/components/side_panel/event_details/helpers");
var _use_rule_with_fallback = require("../../../detection_engine/rule_management/logic/use_rule_with_fallback");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RightPanelContext = /*#__PURE__*/(0, _react.createContext)(undefined);
exports.RightPanelContext = RightPanelContext;
const RightPanelProvider = /*#__PURE__*/(0, _react.memo)(({
  id,
  indexName,
  scopeId,
  children
}) => {
  const {
    browserFields,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    getFieldsData,
    loading,
    refetchFlyoutData,
    searchHit
  } = (0, _use_event_details.useEventDetails)({
    eventId: id,
    indexName
  });
  const {
    ruleId
  } = (0, _helpers.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const {
    rule: maybeRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId);
  const contextValue = (0, _react.useMemo)(() => {
    var _maybeRule$investigat, _maybeRule$investigat2;
    return id && indexName && scopeId && dataAsNestedObject && dataFormattedForFieldBrowser && searchHit ? {
      eventId: id,
      indexName,
      scopeId,
      browserFields,
      dataAsNestedObject,
      dataFormattedForFieldBrowser,
      searchHit,
      investigationFields: (_maybeRule$investigat = maybeRule === null || maybeRule === void 0 ? void 0 : (_maybeRule$investigat2 = maybeRule.investigation_fields) === null || _maybeRule$investigat2 === void 0 ? void 0 : _maybeRule$investigat2.field_names) !== null && _maybeRule$investigat !== void 0 ? _maybeRule$investigat : [],
      refetchFlyoutData,
      getFieldsData,
      isPreview: scopeId === _securitysolutionDataTable.TableId.rulePreview
    } : undefined;
  }, [id, maybeRule, indexName, scopeId, browserFields, dataAsNestedObject, dataFormattedForFieldBrowser, searchHit, refetchFlyoutData, getFieldsData]);
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, null);
  }
  if (!contextValue) {
    return /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, null);
  }
  return /*#__PURE__*/_react.default.createElement(RightPanelContext.Provider, {
    value: contextValue
  }, children);
});
exports.RightPanelProvider = RightPanelProvider;
RightPanelProvider.displayName = 'RightPanelProvider';
const useRightPanelContext = () => {
  const contextValue = (0, _react.useContext)(RightPanelContext);
  if (!contextValue) {
    throw new Error('RightPanelContext can only be used within RightPanelContext provider');
  }
  return contextValue;
};
exports.useRightPanelContext = useRightPanelContext;