"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PanelContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _test_ids = require("./test_ids");
var _flyout_body = require("../../shared/components/flyout_body");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Document details expandable flyout right section, that will display the content
 * of the overview, table and json tabs.
 */
const PanelContent = ({
  selectedTabId,
  tabs
}) => {
  const selectedTabContent = (0, _react.useMemo)(() => {
    var _tabs$find;
    return (_tabs$find = tabs.find(tab => tab.id === selectedTabId)) === null || _tabs$find === void 0 ? void 0 : _tabs$find.content;
  }, [selectedTabId, tabs]);
  return /*#__PURE__*/_react.default.createElement(_flyout_body.FlyoutBody, {
    "data-test-subj": _test_ids.FLYOUT_BODY_TEST_ID
  }, selectedTabContent);
};
exports.PanelContent = PanelContent;
PanelContent.displayName = 'PanelContent';