"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationsSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _analyzer_preview_container = require("./analyzer_preview_container");
var _session_preview_container = require("./session_preview_container");
var _expandable_section = require("./expandable_section");
var _test_ids = require("./test_ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Visualizations section in overview. It contains analyzer preview and session view preview.
 */
const VisualizationsSection = ({
  expanded = false
}) => {
  return /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    expanded: expanded,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.visualizations.sectionTitle",
      defaultMessage: "Visualizations"
    }),
    "data-test-subj": _test_ids.VISUALIZATIONS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_session_preview_container.SessionPreviewContainer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_analyzer_preview_container.AnalyzerPreviewContainer, null));
};
exports.VisualizationsSection = VisualizationsSection;
VisualizationsSection.displayName = 'VisualizationsSection';