"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionPreviewContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _css = require("@emotion/css");
var _use_license = require("../../../../common/hooks/use_license");
var _session_preview = require("./session_preview");
var _use_session_preview = require("../hooks/use_session_preview");
var _use_investigate_in_timeline = require("../../../../detections/components/alerts_table/timeline_actions/use_investigate_in_timeline");
var _context = require("../context");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _expandable_panel = require("../../../shared/components/expandable_panel");
var _test_ids = require("./test_ids");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _actions = require("../../../../timelines/store/timeline/actions");
var _helpers = require("../../../../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timelineId = 'timeline-1';

/**
 * Checks if the SessionView component is available, if so render it or else render an error message
 */
const SessionPreviewContainer = () => {
  const {
    dataAsNestedObject,
    getFieldsData,
    isPreview
  } = (0, _context.useRightPanelContext)();

  // decide whether to show the session view or not
  const sessionViewConfig = (0, _use_session_preview.useSessionPreview)({
    getFieldsData
  });
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const isEnabled = sessionViewConfig && isEnterprisePlus;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const scopedActions = (0, _helpers.getScopedActions)(timelineId);
  const {
    investigateInTimelineAlertClick
  } = (0, _use_investigate_in_timeline.useInvestigateInTimeline)({
    ecsRowData: dataAsNestedObject
  });
  const goToSessionViewTab = (0, _react.useCallback)(() => {
    // open timeline
    investigateInTimelineAlertClick();

    // open session view tab
    startTransaction({
      name: _user_actions.ALERTS_ACTIONS.OPEN_SESSION_VIEW
    });
    if (sessionViewConfig !== null) {
      dispatch((0, _actions.setActiveTabTimeline)({
        id: timelineId,
        activeTab: _securitysolutionDataTable.TimelineTabs.session
      }));
      if (scopedActions) {
        dispatch(scopedActions.updateSessionViewConfig({
          id: timelineId,
          sessionViewConfig
        }));
      }
    }
  }, [dispatch, investigateInTimelineAlertClick, scopedActions, sessionViewConfig, startTransaction]);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const noSessionMessage = !isEnterprisePlus ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.upsellDescription",
    defaultMessage: "This feature requires an {subscription}",
    values: {
      subscription: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/pricing/",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.upsellLinkText",
        defaultMessage: "Enterprise subscription"
      }))
    }
  }) : !sessionViewConfig ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.noDataDescription",
    defaultMessage: "You can only view Linux session details if you\u2019ve enabled the {setting} setting in your Elastic Defend integration policy. Refer to {link} for more information.",
    values: {
      setting: /*#__PURE__*/_react.default.createElement("span", {
        css: (0, _css.css)`
              font-weight: ${euiTheme.font.weight.bold};
            `
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.noDataSettingDescription",
        defaultMessage: "Include session data"
      })),
      link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/guide/en/security/current/session-view.html#enable-session-view",
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.noDataLinkText",
        defaultMessage: "Enable Session View data"
      }))
    }
  }) : null;
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.sessionPreviewTitle",
        defaultMessage: "Session viewer preview"
      }),
      iconType: 'timeline',
      ...(isEnabled && !isPreview && {
        link: {
          callback: goToSessionViewTab,
          tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
            id: "xpack.securitySolution.flyout.right.visualizations.sessionPreview.sessionPreviewTooltip",
            defaultMessage: "Show session viewer"
          })
        }
      })
    },
    "data-test-subj": _test_ids.SESSION_PREVIEW_TEST_ID
  }, isEnabled ? /*#__PURE__*/_react.default.createElement(_session_preview.SessionPreview, null) : noSessionMessage);
};
exports.SessionPreviewContainer = SessionPreviewContainer;