"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _i18nReact = require("@kbn/i18n-react");
var _context = require("../context");
var _expandable_section = require("../../right/components/expandable_section");
var _use_rule_with_fallback = require("../../../../detection_engine/rule_management/logic/use_rule_with_fallback");
var _helpers = require("../../../../detections/pages/detection_engine/rules/helpers");
var _rule_preview_title = require("./rule_preview_title");
var _rule_about_section = require("../../../../detection_engine/rule_management/components/rule_details/rule_about_section");
var _rule_schedule_section = require("../../../../detection_engine/rule_management/components/rule_details/rule_schedule_section");
var _rule_definition_section = require("../../../../detection_engine/rule_management/components/rule_details/rule_definition_section");
var _step_rule_actions = require("../../../../detections/components/rules/step_rule_actions");
var _flyout_loading = require("../../../shared/components/flyout_loading");
var _flyout_error = require("../../../shared/components/flyout_error");
var _test_ids = require("./test_ids");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const panelViewStyle = (0, _css.css)`
  dt {
    font-size: 90% !important;
  }
  text-overflow: ellipsis;
  .euiFlexGroup {
    flex-wrap: inherit;
  }

  .euiFlexItem {
    inline-size: inherit;
    flex-basis: inherit;
  }
`;

/**
 * Rule summary on a preview panel on top of the right section of expandable flyout
 */
const RulePreview = /*#__PURE__*/(0, _react.memo)(() => {
  var _ruleActionsData$acti, _ruleActionsData$resp;
  const {
    ruleId
  } = (0, _context.usePreviewPanelContext)();
  const [rule, setRule] = (0, _react.useState)(null);
  const {
    rule: maybeRule,
    loading: ruleLoading,
    isExistingRule
  } = (0, _use_rule_with_fallback.useRuleWithFallback)(ruleId !== null && ruleId !== void 0 ? ruleId : '');

  // persist rule until refresh is complete
  (0, _react.useEffect)(() => {
    if (maybeRule != null) {
      setRule(maybeRule);
    }
  }, [maybeRule]);
  const {
    ruleActionsData
  } = rule != null ? (0, _helpers.getStepsData)({
    rule,
    detailsView: true
  }) : {
    ruleActionsData: null
  };
  const hasNotificationActions = Boolean(ruleActionsData === null || ruleActionsData === void 0 ? void 0 : (_ruleActionsData$acti = ruleActionsData.actions) === null || _ruleActionsData$acti === void 0 ? void 0 : _ruleActionsData$acti.length);
  const hasResponseActions = Boolean(ruleActionsData === null || ruleActionsData === void 0 ? void 0 : (_ruleActionsData$resp = ruleActionsData.responseActions) === null || _ruleActionsData$resp === void 0 ? void 0 : _ruleActionsData$resp.length);
  const hasActions = ruleActionsData != null && (hasNotificationActions || hasResponseActions);
  return ruleLoading ? /*#__PURE__*/_react.default.createElement(_flyout_loading.FlyoutLoading, {
    "data-test-subj": _test_ids.RULE_PREVIEW_LOADING_TEST_ID
  }) : rule ? /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false,
    "data-test-subj": _test_ids.RULE_PREVIEW_BODY_TEST_ID,
    className: "eui-yScroll"
  }, /*#__PURE__*/_react.default.createElement(_rule_preview_title.RulePreviewTitle, {
    rule: rule,
    isSuppressed: !isExistingRule
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.preview.rule.aboutLabel",
      defaultMessage: "About"
    }),
    expanded: true,
    "data-test-subj": _test_ids.RULE_PREVIEW_ABOUT_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, rule.description), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_rule_about_section.RuleAboutSection, {
    rule: rule,
    hideName: true,
    hideDescription: true,
    type: "row",
    rowGutterSize: "s",
    className: panelViewStyle
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.preview.rule.definitionLabel",
      defaultMessage: "Definition"
    }),
    expanded: false,
    "data-test-subj": _test_ids.RULE_PREVIEW_DEFINITION_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_rule_definition_section.RuleDefinitionSection, {
    rule: rule,
    type: "row",
    rowGutterSize: "s",
    className: panelViewStyle
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.preview.rule.scheduleLabel",
      defaultMessage: "Schedule"
    }),
    expanded: false,
    "data-test-subj": _test_ids.RULE_PREVIEW_SCHEDULE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_rule_schedule_section.RuleScheduleSection, {
    rule: rule,
    type: "row",
    rowGutterSize: "s",
    className: panelViewStyle
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "l"
  }), hasActions && /*#__PURE__*/_react.default.createElement(_expandable_section.ExpandableSection, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.preview.rule.actionsLabel",
      defaultMessage: "Actions"
    }),
    expanded: false,
    "data-test-subj": _test_ids.RULE_PREVIEW_ACTIONS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_step_rule_actions.StepRuleActionsReadOnly, {
    addPadding: false,
    defaultValues: ruleActionsData
  }))) : /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_flyout_error.FlyoutError, null));
});
exports.RulePreview = RulePreview;
RulePreview.displayName = 'RulePreview';