"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CellActions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _context = require("../context");
var _helpers = require("../../../../helpers");
var _helpers2 = require("../../../../timelines/components/side_panel/event_details/helpers");
var _constants = require("../../../../actions/constants");
var _cell_actions = require("../../../../common/components/cell_actions");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Security cell action wrapper for document details flyout
 */
const CellActions = ({
  field,
  value,
  isObjectArray,
  children
}) => {
  const {
    dataFormattedForFieldBrowser,
    scopeId,
    isPreview
  } = (0, _context.useLeftPanelContext)();
  const {
    isAlert
  } = (0, _helpers2.useBasicDataFromDetailsData)(dataFormattedForFieldBrowser);
  const triggerId = isAlert ? _cell_actions.SecurityCellActionsTrigger.DETAILS_FLYOUT : _cell_actions.SecurityCellActionsTrigger.DEFAULT;
  const data = (0, _react.useMemo)(() => ({
    field,
    value
  }), [field, value]);
  const metadata = (0, _react.useMemo)(() => ({
    scopeId,
    isObjectArray
  }), [scopeId, isObjectArray]);
  const disabledActionTypes = (0, _react.useMemo)(() => isPreview ? [_constants.SecurityCellActionType.FILTER, _constants.SecurityCellActionType.TOGGLE_COLUMN] : [], [isPreview]);
  return /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: data,
    mode: _cell_actions.CellActionsMode.HOVER_RIGHT,
    triggerId: triggerId,
    visibleCellActions: 6,
    sourcererScopeId: (0, _helpers.getSourcererScopeId)(scopeId),
    metadata: metadata,
    disabledActionTypes: disabledActionTypes
  }, children);
};
exports.CellActions = CellActions;
CellActions.displayName = 'CellActions';