"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _common = require("@kbn/data-plugin/common");
var _esQuery = require("@kbn/es-query");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _alerts_by_status = require("../../../../overview/components/detection_response/alerts_by_status");
var _use_signal_index = require("../../../../detections/containers/detection_engine/alerts/use_signal_index");
var _alert_count_by_status = require("../../../../common/components/alert_count_by_status");
var _constants = require("../../../../common/store/inputs/constants");
var _types = require("../../../../app/types");
var _filters_global = require("../../../../common/components/filters_global");
var _header_page = require("../../../../common/components/header_page");
var _tab_navigation = require("../../../../common/components/navigation/tab_navigation");
var _search_bar = require("../../../../common/components/search_bar");
var _page_wrapper = require("../../../../common/components/page_wrapper");
var _use_global_time = require("../../../../common/containers/use_global_time");
var _kibana = require("../../../../common/lib/kibana");
var _store = require("../../../../common/store");
var _use_alerts_privileges = require("../../../../detections/containers/detection_engine/alerts/use_alerts_privileges");
var _actions = require("../../store/actions");
var _actions2 = require("../../../../common/store/inputs/actions");
var _spy_routes = require("../../../../common/utils/route/spy_routes");
var _details_tabs = require("./details_tabs");
var _nav_tabs = require("./nav_tabs");
var _helpers = require("./helpers");
var _helpers2 = require("../../../../timelines/components/timeline/helpers");
var _use_full_screen = require("../../../../common/containers/use_full_screen");
var _defaults = require("../../../../timelines/store/timeline/defaults");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_selector = require("../../../../common/hooks/use_selector");
var _use_invalid_filter_query = require("../../../../common/hooks/use_invalid_filter_query");
var _last_event_time = require("../../../../common/components/last_event_time");
var _search_strategy = require("../../../../../common/search_strategy");
var _anomaly_table_provider = require("../../../../common/components/ml/anomaly/anomaly_table_provider");
var _user_overview = require("../../../../overview/components/user_overview");
var _observed_details = require("../../containers/users/observed_details");
var _manage_query = require("../../../../common/components/page/manage_query");
var _score_interval_to_datetime = require("../../../../common/components/ml/score/score_interval_to_datetime");
var _get_criteria_from_users_type = require("../../../../common/components/ml/criteria/get_criteria_from_users_type");
var _model = require("../../store/model");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var _use_ml_capabilities = require("../../../../common/components/ml/hooks/use_ml_capabilities");
var _landing_page = require("../../../../common/components/landing_page");
var _helper_hooks = require("../../../../helper_hooks");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const QUERY_ID = 'UsersDetailsQueryId';
const ES_USER_FIELD = 'user.name';
const UsersDetailsComponent = ({
  detailName,
  usersDetailsPagePath
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const hasEntityAnalyticsCapability = (0, _helper_hooks.useHasSecurityCapability)('entity-analytics');
  const getTable = (0, _react.useMemo)(() => _securitysolutionDataTable.dataTableSelectors.getTableByIdSelector(), []);
  const graphEventId = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTable;
    return ((_getTable = getTable(state, _securitysolutionDataTable.TableId.hostsPageEvents)) !== null && _getTable !== void 0 ? _getTable : _defaults.timelineDefaults).graphEventId;
  });
  const getGlobalFiltersQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalFiltersQuerySelector(), []);
  const getGlobalQuerySelector = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuerySelector(), []);
  const query = (0, _use_selector.useDeepEqualSelector)(getGlobalQuerySelector);
  const globalFilters = (0, _use_selector.useDeepEqualSelector)(getGlobalFiltersQuerySelector);
  const {
    signalIndexName
  } = (0, _use_signal_index.useSignalIndex)();
  const {
    hasKibanaREAD,
    hasIndexRead
  } = (0, _use_alerts_privileges.useAlertsPrivileges)();
  const canReadAlerts = hasKibanaREAD && hasIndexRead;
  const {
    to,
    from,
    deleteQuery,
    setQuery,
    isInitializing
  } = (0, _use_global_time.useGlobalTime)();
  const {
    globalFullScreen
  } = (0, _use_full_screen.useGlobalFullScreen)();
  const {
    services: {
      uiSettings
    }
  } = (0, _kibana.useKibana)();
  const usersDetailsPageFilters = (0, _react.useMemo)(() => (0, _helpers.getUsersDetailsPageFilters)(detailName), [detailName]);
  const {
    indicesExist,
    indexPattern,
    selectedPatterns,
    sourcererDataView
  } = (0, _sourcerer.useSourcererDataView)();
  const [rawFilteredQuery, kqlError] = (0, _react.useMemo)(() => {
    try {
      return [(0, _esQuery.buildEsQuery)(indexPattern, [query], [...usersDetailsPageFilters, ...globalFilters], (0, _common.getEsQueryConfig)(uiSettings))];
    } catch (e) {
      return [undefined, e];
    }
  }, [globalFilters, indexPattern, query, uiSettings, usersDetailsPageFilters]);
  const stringifiedAdditionalFilters = JSON.stringify(rawFilteredQuery);
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: QUERY_ID,
    filterQuery: stringifiedAdditionalFilters,
    kqlError,
    query,
    startDate: from,
    endDate: to
  });
  (0, _react.useEffect)(() => {
    dispatch((0, _actions.setUsersDetailsTablesActivePageToZero)());
  }, [dispatch, detailName]);
  const [loading, {
    inspect,
    userDetails,
    refetch
  }] = (0, _observed_details.useObservedUserDetails)({
    id: QUERY_ID,
    endDate: to,
    startDate: from,
    userName: detailName,
    indexNames: selectedPatterns,
    skip: selectedPatterns.length === 0
  });
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  (0, _manage_query.useQueryInspector)({
    setQuery,
    deleteQuery,
    refetch,
    inspect,
    loading,
    queryId: QUERY_ID
  });
  const narrowDateRange = (0, _react.useCallback)((score, interval) => {
    const fromTo = (0, _score_interval_to_datetime.scoreIntervalToDateTime)(score, interval);
    dispatch((0, _actions2.setAbsoluteRangeDatePicker)({
      id: _constants.InputsModelId.global,
      from: fromTo.from,
      to: fromTo.to
    }));
  }, [dispatch]);
  const entityFilter = (0, _react.useMemo)(() => ({
    field: ES_USER_FIELD,
    value: detailName
  }), [detailName]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, indicesExist ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiWindowEvent, {
    event: "resize",
    handler: _fp.noop
  }), /*#__PURE__*/_react.default.createElement(_filters_global.FiltersGlobal, {
    show: (0, _helpers2.showGlobalFilters)({
      globalFullScreen,
      graphEventId
    })
  }, /*#__PURE__*/_react.default.createElement(_search_bar.SiemSearchBar, {
    sourcererDataView: sourcererDataView,
    id: _constants.InputsModelId.global
  })), /*#__PURE__*/_react.default.createElement(_page_wrapper.SecuritySolutionPageWrapper, {
    noPadding: globalFullScreen
  }, /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    subtitle: /*#__PURE__*/_react.default.createElement(_last_event_time.LastEventTime, {
      indexKey: _search_strategy.LastEventIndexKey.userDetails,
      indexNames: selectedPatterns,
      userName: detailName
    }),
    title: detailName
  }), /*#__PURE__*/_react.default.createElement(_anomaly_table_provider.AnomalyTableProvider, {
    criteriaFields: (0, _get_criteria_from_users_type.getCriteriaFromUsersType)(_model.UsersType.details, detailName),
    startDate: from,
    endDate: to,
    skip: isInitializing
  }, ({
    isLoadingAnomaliesData,
    anomaliesData,
    jobNameById
  }) => /*#__PURE__*/_react.default.createElement(_user_overview.UserOverview, {
    userName: detailName,
    id: QUERY_ID,
    isInDetailsSidePanel: false,
    data: userDetails,
    anomaliesData: anomaliesData,
    isLoadingAnomaliesData: isLoadingAnomaliesData,
    loading: loading,
    startDate: from,
    endDate: to,
    narrowDateRange: narrowDateRange,
    indexPatterns: selectedPatterns,
    jobNameById: jobNameById
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), canReadAlerts && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alerts_by_status.AlertsByStatus, {
    signalIndexName: signalIndexName,
    entityFilter: entityFilter,
    additionalFilters: rawFilteredQuery ? [rawFilteredQuery] : []
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_alert_count_by_status.AlertCountByRuleByStatus, {
    entityFilter: entityFilter,
    signalIndexName: signalIndexName,
    additionalFilters: rawFilteredQuery ? [rawFilteredQuery] : []
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: (0, _nav_tabs.navTabsUsersDetails)(detailName, (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities), hasEntityAnalyticsCapability)
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_details_tabs.UsersDetailsTabs, {
    deleteQuery: deleteQuery,
    detailName: detailName,
    filterQuery: stringifiedAdditionalFilters,
    from: from,
    indexNames: selectedPatterns,
    indexPattern: indexPattern,
    isInitializing: isInitializing,
    userDetailFilter: usersDetailsPageFilters,
    setQuery: setQuery,
    to: to,
    type: _model.UsersType.details,
    usersDetailsPagePath: usersDetailsPagePath
  }))) : /*#__PURE__*/_react.default.createElement(_landing_page.LandingPageComponent, null), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _types.SecurityPageName.users
  }));
};
UsersDetailsComponent.displayName = 'UsersDetailsComponent';
const UsersDetails = /*#__PURE__*/_react.default.memo(UsersDetailsComponent);
exports.UsersDetails = UsersDetails;