"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersKpiComponent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _authentications = require("./authentications");
var _total_users = require("./total_users");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UsersKpiComponent = /*#__PURE__*/_react.default.memo(({
  filterQuery,
  from,
  indexNames,
  to,
  setQuery,
  skip,
  updateDateRange
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  wrap: true
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 1
}, /*#__PURE__*/_react.default.createElement(_total_users.TotalUsersKpi, {
  filterQuery: filterQuery,
  from: from,
  indexNames: indexNames,
  to: to,
  updateDateRange: updateDateRange,
  setQuery: setQuery,
  skip: skip
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: 2
}, /*#__PURE__*/_react.default.createElement(_authentications.UsersKpiAuthentications, {
  filterQuery: filterQuery,
  from: from,
  indexNames: indexNames,
  to: to,
  updateDateRange: updateDateRange,
  setQuery: setQuery,
  skip: skip
}))));
exports.UsersKpiComponent = UsersKpiComponent;
UsersKpiComponent.displayName = 'UsersKpiComponent';