"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkRoutes = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _eui = require("@elastic/eui");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _network = require("../../../../../common/search_strategy/security_solution/network");
var _ = require(".");
var _events_tab = require("../../../../common/components/events_tab");
var _anomalies_network_table = require("../../../../common/components/ml/tables/anomalies_network_table");
var _utils = require("../../../../common/components/visualization_actions/utils");
var _anomalies_query_tab_body = require("../../../../common/containers/anomalies/anomalies_query_tab_body");
var _conditional_flex_group = require("./conditional_flex_group");
var _types = require("./types");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NetworkRoutes = /*#__PURE__*/_react.default.memo(({
  type,
  to,
  filterQuery,
  isInitializing,
  from,
  indexPattern,
  indexNames,
  setQuery
}) => {
  const networkAnomaliesFilterQuery = {
    bool: {
      should: [{
        exists: {
          field: 'source.ip'
        }
      }, {
        exists: {
          field: 'destination.ip'
        }
      }],
      minimum_should_match: 1
    }
  };
  const commonProps = {
    startDate: from,
    endDate: to,
    indexNames,
    skip: isInitializing,
    type,
    setQuery,
    filterQuery
  };
  const tabProps = {
    ...commonProps,
    indexPattern
  };
  const anomaliesProps = {
    ...commonProps,
    anomaliesFilterQuery: networkAnomaliesFilterQuery,
    AnomaliesTableComponent: _anomalies_network_table.AnomaliesNetworkTable
  };
  return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.dns})`
  }, /*#__PURE__*/_react.default.createElement(_.DnsQueryTabBody, tabProps)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.flows})`
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_conditional_flex_group.ConditionalFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.IPsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.source
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.IPsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.destination
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_conditional_flex_group.ConditionalFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.CountriesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.source
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_.CountriesQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.destination
  })))))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.http})`
  }, /*#__PURE__*/_react.default.createElement(_.HttpQueryTabBody, tabProps)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.tls})`
  }, /*#__PURE__*/_react.default.createElement(_.TlsQueryTabBody, (0, _extends2.default)({}, tabProps, {
    flowTarget: _network.FlowTargetSourceDest.source
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.anomalies})`
  }, /*#__PURE__*/_react.default.createElement(_anomalies_query_tab_body.AnomaliesQueryTabBody, (0, _extends2.default)({}, anomaliesProps, {
    AnomaliesTableComponent: _anomalies_network_table.AnomaliesNetworkTable
  }))), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: `${_constants.NETWORK_PATH}/:tabName(${_types.NetworkRouteType.events})`
  }, /*#__PURE__*/_react.default.createElement(_events_tab.EventsQueryTabBody, (0, _extends2.default)({
    additionalFilters: _utils.sourceOrDestinationIpExistsFilter,
    tableId: _securitysolutionDataTable.TableId.networkPageEvents
  }, tabProps))));
});
exports.NetworkRoutes = NetworkRoutes;
NetworkRoutes.displayName = 'NetworkRoutes';