"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navTabsNetwork = void 0;
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("../translations"));
var _types = require("./types");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTabsOnNetworkUrl = tabName => `${_constants.NETWORK_PATH}/${tabName}`;
const navTabsNetwork = hasMlUserPermissions => {
  const networkNavTabs = {
    [_types.NetworkRouteType.flows]: {
      id: _types.NetworkRouteType.flows,
      name: i18n.NAVIGATION_FLOWS_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.flows),
      disabled: false
    },
    [_types.NetworkRouteType.dns]: {
      id: _types.NetworkRouteType.dns,
      name: i18n.NAVIGATION_DNS_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.dns),
      disabled: false
    },
    [_types.NetworkRouteType.http]: {
      id: _types.NetworkRouteType.http,
      name: i18n.NAVIGATION_HTTP_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.http),
      disabled: false
    },
    [_types.NetworkRouteType.tls]: {
      id: _types.NetworkRouteType.tls,
      name: i18n.NAVIGATION_TLS_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.tls),
      disabled: false
    },
    [_types.NetworkRouteType.anomalies]: {
      id: _types.NetworkRouteType.anomalies,
      name: i18n.NAVIGATION_ANOMALIES_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.anomalies),
      disabled: false
    },
    [_types.NetworkRouteType.events]: {
      id: _types.NetworkRouteType.events,
      name: i18n.NAVIGATION_EVENTS_TITLE,
      href: getTabsOnNetworkUrl(_types.NetworkRouteType.events),
      disabled: false
    }
  };
  return hasMlUserPermissions ? networkNavTabs : (0, _fp.omit)([_types.NetworkRouteType.anomalies], networkNavTabs);
};
exports.navTabsNetwork = navTabsNetwork;