"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFlag = exports.CountryFlagAndName = exports.CountryFlag = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _i18nIsoCountries = _interopRequireDefault(require("i18n-iso-countries"));
var _en = _interopRequireDefault(require("i18n-iso-countries/langs/en.json"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Fixes vertical alignment of the flag
const FlagWrapper = _styledComponents.default.span`
  position: relative;
  top: 1px;
`;

/**
 * Returns the flag for the specified country code, or null if the specified
 * country code could not be converted
 * Example: `US` -> 🇺🇸
 */
const getFlag = countryCode => countryCode && countryCode.length === 2 ? countryCode.toUpperCase().replace(/./g, c => String.fromCharCode(55356, 56741 + c.charCodeAt(0))) : null;

/** Renders an emoji flag for the specified country code */
exports.getFlag = getFlag;
const CountryFlag = /*#__PURE__*/(0, _react.memo)(({
  countryCode,
  displayCountryNameOnHover = false
}) => {
  (0, _react.useEffect)(() => {
    if (displayCountryNameOnHover && (0, _fp.isEmpty)(_i18nIsoCountries.default.getNames('en'))) {
      _i18nIsoCountries.default.registerLocale(_en.default);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const flag = getFlag(countryCode);
  if (flag !== null) {
    return displayCountryNameOnHover ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18nIsoCountries.default.getName(countryCode, 'en')
    }, /*#__PURE__*/_react.default.createElement(FlagWrapper, {
      "data-test-subj": "country-flag"
    }, flag)) : /*#__PURE__*/_react.default.createElement(FlagWrapper, {
      "data-test-subj": "country-flag"
    }, flag);
  }
  return null;
});
exports.CountryFlag = CountryFlag;
CountryFlag.displayName = 'CountryFlag';

/** Renders an emoji flag with country name for the specified country code */
const CountryFlagAndName = /*#__PURE__*/(0, _react.memo)(({
  countryCode,
  displayCountryNameOnHover = false
}) => {
  const [localesLoaded, setLocalesLoaded] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if ((0, _fp.isEmpty)(_i18nIsoCountries.default.getNames('en'))) {
      _i18nIsoCountries.default.registerLocale(_en.default);
    }
    setLocalesLoaded(true);
  }, []);
  const flag = getFlag(countryCode);
  if (flag !== null && localesLoaded) {
    return displayCountryNameOnHover ? /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      position: "top",
      content: _i18nIsoCountries.default.getName(countryCode, 'en')
    }, /*#__PURE__*/_react.default.createElement(FlagWrapper, {
      "data-test-subj": "country-flag"
    }, flag)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(FlagWrapper, {
      "data-test-subj": "country-flag"
    }, flag), ` ${_i18nIsoCountries.default.getName(countryCode, 'en')}`);
  }
  return null;
});
exports.CountryFlagAndName = CountryFlagAndName;
CountryFlagAndName.displayName = 'CountryFlagAndName';