"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNIT = exports.UNIQUE_DOMAINS = exports.TOTAL_QUERIES = exports.TOP_DNS_DOMAINS = exports.TOOLTIP = exports.ROWS_5 = exports.ROWS_10 = exports.REGISTERED_DOMAIN = exports.INCLUDE_PTR_RECORDS = exports.DNS_BYTES_OUT = exports.DNS_BYTES_IN = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TOP_DNS_DOMAINS = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.title', {
  defaultMessage: 'Top DNS domains'
});
exports.TOP_DNS_DOMAINS = TOP_DNS_DOMAINS;
const UNIT = totalCount => _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.unit', {
  values: {
    totalCount
  },
  defaultMessage: `{totalCount, plural, =1 {domain} other {domains}}`
});
exports.UNIT = UNIT;
const TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.helperTooltip', {
  defaultMessage: 'This shows DNS protocol traffic only and can be useful for hunting domains used in DNS data exfiltration.'
});
exports.TOOLTIP = TOOLTIP;
const REGISTERED_DOMAIN = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.registeredDomain', {
  defaultMessage: 'Registered domain'
});
exports.REGISTERED_DOMAIN = REGISTERED_DOMAIN;
const TOTAL_QUERIES = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.TotalQueriesTitle', {
  defaultMessage: 'Total queries'
});
exports.TOTAL_QUERIES = TOTAL_QUERIES;
const UNIQUE_DOMAINS = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.uniqueDomainsTitle', {
  defaultMessage: 'Unique domains'
});
exports.UNIQUE_DOMAINS = UNIQUE_DOMAINS;
const DNS_BYTES_IN = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.bytesInTitle', {
  defaultMessage: 'DNS bytes in'
});
exports.DNS_BYTES_IN = DNS_BYTES_IN;
const DNS_BYTES_OUT = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.column.bytesOutTitle', {
  defaultMessage: 'DNS bytes out'
});
exports.DNS_BYTES_OUT = DNS_BYTES_OUT;
const INCLUDE_PTR_RECORDS = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.select.includePtrRecords', {
  defaultMessage: 'Include PTR records'
});
exports.INCLUDE_PTR_RECORDS = INCLUDE_PTR_RECORDS;
const ROWS_5 = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.rows', {
  values: {
    numRows: 5
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_5 = ROWS_5;
const ROWS_10 = _i18n.i18n.translate('xpack.securitySolution.networkDnsTable.rows', {
  values: {
    numRows: 10
  },
  defaultMessage: '{numRows} {numRows, plural, =0 {rows} =1 {row} other {rows}}'
});
exports.ROWS_10 = ROWS_10;