"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NetworkDnsTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _store = require("../../store");
var _paginated_table = require("../../../components/paginated_table");
var _use_selector = require("../../../../common/hooks/use_selector");
var _columns = require("./columns");
var _is_ptr_included = require("./is_ptr_included");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const tableType = _store.networkModel.NetworkTableType.dns;
const rowItems = [{
  text: i18n.ROWS_5,
  numberOfRow: 5
}, {
  text: i18n.ROWS_10,
  numberOfRow: 10
}];
const NetworkDnsTableComponent = ({
  data,
  fakeTotalCount,
  id,
  isInspect,
  loading,
  loadPage,
  showMorePagesIndicator,
  setQuerySkip,
  totalCount,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const getNetworkDnsSelector = (0, _react.useMemo)(() => _store.networkSelectors.dnsSelector(), []);
  const {
    activePage,
    isPtrIncluded,
    limit,
    sort
  } = (0, _use_selector.useDeepEqualSelector)(getNetworkDnsSelector);
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      limit: newLimit
    }
  })), [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      activePage: newPage
    }
  })), [dispatch, type]);
  const onChange = (0, _react.useCallback)(criteria => {
    if (criteria.sort != null) {
      const newDnsSortField = {
        field: criteria.sort.field.split('.')[1],
        direction: criteria.sort.direction
      };
      if (!(0, _fastDeepEqual.default)(newDnsSortField, sort)) {
        dispatch(_store.networkActions.updateNetworkTable({
          networkType: type,
          tableType,
          updates: {
            sort: newDnsSortField
          }
        }));
      }
    }
  }, [sort, type, dispatch]);
  const onChangePtrIncluded = (0, _react.useCallback)(() => dispatch(_store.networkActions.updateNetworkTable({
    networkType: type,
    tableType,
    updates: {
      isPtrIncluded: !isPtrIncluded
    }
  })), [dispatch, type, isPtrIncluded]);
  const columns = (0, _react.useMemo)(() => (0, _columns.getNetworkDnsColumns)(), []);
  const sorting = (0, _react.useMemo)(() => ({
    field: `node.${sort.field}`,
    direction: sort.direction
  }), [sort.direction, sort.field]);
  const HeaderSupplement = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_is_ptr_included.IsPtrIncluded, {
    isPtrIncluded: isPtrIncluded,
    onChange: onChangePtrIncluded
  }), [isPtrIncluded, onChangePtrIncluded]);
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: `table-${tableType}`,
    headerCount: totalCount,
    headerSupplement: HeaderSupplement,
    headerTitle: i18n.TOP_DNS_DOMAINS,
    headerTooltip: i18n.TOOLTIP,
    headerUnit: i18n.UNIT(totalCount),
    id: id,
    itemsPerRow: rowItems,
    isInspect: isInspect,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    onChange: onChange,
    pageOfItems: data,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: showMorePagesIndicator,
    sorting: sorting,
    totalCount: fakeTotalCount,
    updateActivePage: updateActivePage,
    updateLimitPagination: updateLimitPagination
  });
};
NetworkDnsTableComponent.displayName = 'NetworkDnsTableComponent';
const NetworkDnsTable = /*#__PURE__*/_react.default.memo(NetworkDnsTableComponent);
exports.NetworkDnsTable = NetworkDnsTable;