"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SOURCE_IP_FIELD_NAME = exports.Ip = exports.IP_FIELD_TYPE = exports.DESTINATION_IP_FIELD_NAME = void 0;
var _react = _interopRequireDefault(require("react"));
var _formatted_field = require("../../../../timelines/components/timeline/body/renderers/formatted_field");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SOURCE_IP_FIELD_NAME = 'source.ip';
exports.SOURCE_IP_FIELD_NAME = SOURCE_IP_FIELD_NAME;
const DESTINATION_IP_FIELD_NAME = 'destination.ip';
exports.DESTINATION_IP_FIELD_NAME = DESTINATION_IP_FIELD_NAME;
const IP_FIELD_TYPE = 'ip';

/**
 * Renders text containing a draggable IP address (e.g. `source.ip`,
 * `destination.ip`) that contains a hyperlink
 */
exports.IP_FIELD_TYPE = IP_FIELD_TYPE;
const Ip = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  fieldName,
  isDraggable,
  value
}) => /*#__PURE__*/_react.default.createElement(_formatted_field.FormattedFieldValue, {
  contextId: contextId,
  "data-test-subj": "formatted-ip",
  eventId: eventId,
  fieldName: fieldName,
  isDraggable: isDraggable,
  fieldType: IP_FIELD_TYPE,
  value: value,
  truncate: true
}));
exports.Ip = Ip;
Ip.displayName = 'Ip';