"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlowTargetSelect = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const toggleTargetOptions = (id, displayText) => [{
  id: `${id}-select-flow-target-${_search_strategy.FlowTarget.source}`,
  value: _search_strategy.FlowTarget.source,
  inputDisplay: displayText[0] || i18n.SOURCE,
  directions: [_search_strategy.FlowDirection.uniDirectional, _search_strategy.FlowDirection.biDirectional]
}, {
  id: `${id}-select-flow-target-${_search_strategy.FlowTarget.destination}`,
  value: _search_strategy.FlowTarget.destination,
  inputDisplay: displayText[1] || i18n.DESTINATION,
  directions: [_search_strategy.FlowDirection.uniDirectional, _search_strategy.FlowDirection.biDirectional]
}, {
  id: `${id}-select-flow-target-${_search_strategy.FlowTarget.client}`,
  value: _search_strategy.FlowTarget.client,
  inputDisplay: displayText[2] || i18n.CLIENT,
  directions: [_search_strategy.FlowDirection.biDirectional]
}, {
  id: `${id}-select-flow-target-${_search_strategy.FlowTarget.server}`,
  value: _search_strategy.FlowTarget.server,
  inputDisplay: displayText[3] || i18n.SERVER,
  directions: [_search_strategy.FlowDirection.biDirectional]
}];
const FlowTargetSelectComponent = ({
  id,
  isLoading = false,
  selectedDirection,
  selectedTarget,
  displayTextOverride = [],
  updateFlowTargetAction
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
  options: selectedDirection ? toggleTargetOptions(id, displayTextOverride).filter(option => option.directions.includes(selectedDirection)) : toggleTargetOptions(id, displayTextOverride),
  valueOfSelected: selectedTarget,
  onChange: updateFlowTargetAction,
  isLoading: isLoading
});
const FlowTargetSelect = /*#__PURE__*/_react.default.memo(FlowTargetSelectComponent);
exports.FlowTargetSelect = FlowTargetSelect;