"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getRiskScoreIndexStatus = void 0;
var _kibana = require("../../../../common/lib/kibana");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getRiskScoreIndexStatus = async params => {
  const {
    indexName,
    entity
  } = params.query;
  return _kibana.KibanaServices.get().http.fetch(_constants.RISK_SCORE_INDEX_STATUS_API_URL, {
    method: 'GET',
    version: '1',
    query: {
      indexName,
      entity
    },
    asSystemRequest: true,
    signal: params.signal
  });
};
exports.getRiskScoreIndexStatus = getRiskScoreIndexStatus;