"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scoreFormatter = exports.RiskScoreOverTime = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _common = require("../../../../common/components/charts/common");
var _kibana = require("../../../../common/lib/kibana");
var _utils = require("../../../../common/components/utils");
var _header_section = require("../../../../common/components/header_section");
var _inspect = require("../../../../common/components/inspect");
var translations = _interopRequireWildcard(require("./translations"));
var _formatted_date = require("../../../../common/components/formatted_date");
var _search_strategy = require("../../../../../common/search_strategy");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _visualization_embeddable = require("../../../../common/components/visualization_actions/visualization_embeddable");
var _risk_score_over_time_area = require("../../../../common/components/visualization_actions/lens_attributes/common/risk_scores/risk_score_over_time_area");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RISKY_THRESHOLD = 70;
const DEFAULT_CHART_HEIGHT = 250;
const CHART_HEIGHT = 180;
const StyledEuiText = (0, _styledComponents.default)(_eui.EuiText)`
  font-size: 9px;
  font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  margin-right: ${({
  theme
}) => theme.eui.euiSizeXS};
`;
const LoadingChart = (0, _styledComponents.default)(_eui.EuiLoadingChart)`
  display: block;
  text-align: center;
`;
const scoreFormatter = d => Math.round(d).toString();
exports.scoreFormatter = scoreFormatter;
const RiskScoreOverTimeComponent = ({
  from,
  to,
  riskScore,
  loading,
  queryId,
  riskEntity,
  title,
  toggleStatus,
  toggleQuery
}) => {
  const timeZone = (0, _kibana.useTimeZone)();
  const dataTimeFormatter = (0, _react.useMemo)(() => (0, _utils.histogramDateTimeFormatter)([from, to]), [from, to]);
  const headerFormatter = (0, _react.useCallback)(({
    value
  }) => /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: value
  }), []);
  const {
    baseTheme,
    theme
  } = (0, _common.useThemes)();
  const graphData = (0, _react.useMemo)(() => {
    var _riskScore$map$revers;
    return (_riskScore$map$revers = riskScore === null || riskScore === void 0 ? void 0 : riskScore.map(data => ({
      x: data['@timestamp'],
      y: ((0, _search_strategy.isUserRiskScore)(data) ? data.user : data.host).risk.calculated_score_norm
    })).reverse()) !== null && _riskScore$map$revers !== void 0 ? _riskScore$map$revers : [];
  }, [riskScore]);
  const spaceId = (0, _use_space_id.useSpaceId)();
  const isChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('chartEmbeddablesEnabled');
  const timerange = (0, _react.useMemo)(() => ({
    from,
    to
  }), [from, to]);
  return /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "RiskScoreOverTime"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 'none'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: title,
    hideSubtitle: true,
    toggleQuery: toggleQuery,
    toggleStatus: toggleStatus
  })), toggleStatus && !isChartEmbeddablesEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: queryId,
    title: title
  }))), toggleStatus && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, isChartEmbeddablesEnabled && spaceId ? /*#__PURE__*/_react.default.createElement(_visualization_embeddable.VisualizationEmbeddable, {
    applyGlobalQueriesAndFilters: false,
    timerange: timerange,
    getLensAttributes: _risk_score_over_time_area.getRiskScoreOverTimeAreaAttributes,
    stackByField: riskEntity,
    id: `${queryId}-embeddable`,
    height: CHART_HEIGHT,
    extraOptions: {
      spaceId
    }
  }) : /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: DEFAULT_CHART_HEIGHT
    }
  }, loading ? /*#__PURE__*/_react.default.createElement(LoadingChart, {
    size: "l",
    "data-test-subj": "RiskScoreOverTime-loading"
  }) : /*#__PURE__*/_react.default.createElement(_charts.Chart, null, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    headerFormatter: headerFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, (0, _extends2.default)({}, _common.chartDefaultSettings, {
    baseTheme: baseTheme,
    theme: theme,
    locale: _i18n.i18n.getLocale()
  })), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "bottom",
    position: _charts.Position.Bottom,
    tickFormat: dataTimeFormatter,
    gridLine: {
      visible: true,
      strokeWidth: 1,
      opacity: 1,
      dash: [3, 5]
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    domain: {
      min: 0,
      max: 100
    },
    id: "left",
    position: _charts.Position.Left,
    ticks: 3,
    style: {
      tickLine: {
        visible: false
      },
      tickLabel: {
        padding: 10
      }
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.LineSeries, {
    id: "RiskOverTime",
    name: translations.RISK_SCORE,
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear,
    xAccessor: "x",
    yAccessors: ['y'],
    timeZone: timeZone,
    data: graphData,
    tickFormat: scoreFormatter
  }), /*#__PURE__*/_react.default.createElement(_charts.LineAnnotation, {
    id: "RiskOverTime_annotation",
    domainType: _charts.AnnotationDomainType.YDomain,
    dataValues: [{
      dataValue: RISKY_THRESHOLD,
      details: `${RISKY_THRESHOLD}`,
      header: translations.RISK_THRESHOLD
    }],
    markerPosition: "left",
    style: {
      line: {
        strokeWidth: 1,
        stroke: _uiTheme.euiThemeVars.euiColorDanger,
        opacity: 1
      }
    },
    marker: /*#__PURE__*/_react.default.createElement(StyledEuiText, {
      color: _uiTheme.euiThemeVars.euiColorDarkestShade
    }, translations.RISKY)
  })))))));
};
RiskScoreOverTimeComponent.displayName = 'RiskScoreOverTimeComponent';
const RiskScoreOverTime = /*#__PURE__*/_react.default.memo(RiskScoreOverTimeComponent);
exports.RiskScoreOverTime = RiskScoreOverTime;
RiskScoreOverTime.displayName = 'RiskScoreOverTime';